unit AAAObju;
{ Generated by MakeComp 1.03 from AAATYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULIType,
  AAAType;

type
  TAAAObj = class(TULObj)
  protected
    function GetAAAName: TAAAName;
    procedure SetAAAName(AAAAName: TAAAName);
    function GetAAADesc: TAAADesc;
    procedure SetAAADesc(AAAADesc: TAAADesc);
    function GetSeqsDir: string;
    procedure SetSeqsDir(ASeqsDir: string);
    function GetPrgsDir: string;
    procedure SetPrgsDir(APrgsDir: string);
    function GetMethodsDir: string;
    procedure SetMethodsDir(AMethodsDir: string);
    function GetSeqFileName: string;
    procedure SetSeqFileName(ASeqFileName: string);
    function GetPrgFileName: string;
    procedure SetPrgFileName(APrgFileName: string);
    function GetMethodFileName: string;
    procedure SetMethodFileName(AMethodFileName: string);
    function GetP1_FLOW: TFlowRate;
    procedure SetP1_FLOW(AP1_FLOW: TFlowRate);
    function GetP1_PRESS_L: TPressure;
    procedure SetP1_PRESS_L(AP1_PRESS_L: TPressure);
    function GetP1_PRESS_H: TFlowRate;
    procedure SetP1_PRESS_H(AP1_PRESS_H: TFlowRate);
    function GetP1PressDev: TDeviation;
    procedure SetP1PressDev(AP1PressDev: TDeviation);
    function GetP2_FLOW: TFlowRate;
    procedure SetP2_FLOW(AP2_FLOW: TFlowRate);
    function GetP2_PRESS_L: TPressure;
    procedure SetP2_PRESS_L(AP2_PRESS_L: TPressure);
    function GetP2_PRESS_H: TFlowRate;
    procedure SetP2_PRESS_H(AP2_PRESS_H: TFlowRate);
    function GetP2PressDev: TDeviation;
    procedure SetP2PressDev(AP2PressDev: TDeviation);
    function GetAS_TEMP1RQ: TTemperature;
    procedure SetAS_TEMP1RQ(AAS_TEMP1RQ: TTemperature);
    function GetAsTempMinDif: TTemperature;
    procedure SetAsTempMinDif(AAsTempMinDif: TTemperature);
    function GetAsTempMaxDif: TTemperature;
    procedure SetAsTempMaxDif(AAsTempMaxDif: TTemperature);
    function GetAsTempDev: TDeviation;
    procedure SetAsTempDev(AAsTempDev: TDeviation);
    function GetDET_TEMP1RQ: TTemperature;
    procedure SetDET_TEMP1RQ(ADET_TEMP1RQ: TTemperature);
    function GetDetTempMinDif: TTemperature;
    procedure SetDetTempMinDif(ADetTempMinDif: TTemperature);
    function GetDetTempMaxDif: TTemperature;
    procedure SetDetTempMaxDif(ADetTempMaxDif: TTemperature);
    function GetDetTempDev: TDeviation;
    procedure SetDetTempDev(ADetTempDev: TDeviation);
    function GetAAAState: TAAAState;
    procedure SetAAAState(AAAAState: TAAAState);
    function GetPumpStartInhibit: boolean;
    procedure SetPumpStartInhibit(APumpStartInhibit: boolean);
    function GetRunWhenReady: boolean;
    procedure SetRunWhenReady(ARunWhenReady: boolean);
    function GetCoolerBlockEnabled: boolean;
    procedure SetCoolerBlockEnabled(ACoolerBlockEnabled: boolean);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property AAAName: TAAAName
      read GetAAAName write SetAAAName;
    property AAADesc: TAAADesc
      read GetAAADesc write SetAAADesc;
    property SeqsDir: string
      read GetSeqsDir write SetSeqsDir;
    property PrgsDir: string
      read GetPrgsDir write SetPrgsDir;
    property MethodsDir: string
      read GetMethodsDir write SetMethodsDir;
    property SeqFileName: string
      read GetSeqFileName write SetSeqFileName;
    property PrgFileName: string
      read GetPrgFileName write SetPrgFileName;
    property MethodFileName: string
      read GetMethodFileName write SetMethodFileName;
    property P1_FLOW: TFlowRate
      read GetP1_FLOW write SetP1_FLOW;
    property P1_PRESS_L: TPressure
      read GetP1_PRESS_L write SetP1_PRESS_L;
    property P1_PRESS_H: TFlowRate
      read GetP1_PRESS_H write SetP1_PRESS_H;
    property P1PressDev: TDeviation
      read GetP1PressDev write SetP1PressDev;
    property P2_FLOW: TFlowRate
      read GetP2_FLOW write SetP2_FLOW;
    property P2_PRESS_L: TPressure
      read GetP2_PRESS_L write SetP2_PRESS_L;
    property P2_PRESS_H: TFlowRate
      read GetP2_PRESS_H write SetP2_PRESS_H;
    property P2PressDev: TDeviation
      read GetP2PressDev write SetP2PressDev;
    property AS_TEMP1RQ: TTemperature
      read GetAS_TEMP1RQ write SetAS_TEMP1RQ;
    property AsTempMinDif: TTemperature
      read GetAsTempMinDif write SetAsTempMinDif;
    property AsTempMaxDif: TTemperature
      read GetAsTempMaxDif write SetAsTempMaxDif;
    property AsTempDev: TDeviation
      read GetAsTempDev write SetAsTempDev;
    property DET_TEMP1RQ: TTemperature
      read GetDET_TEMP1RQ write SetDET_TEMP1RQ;
    property DetTempMinDif: TTemperature
      read GetDetTempMinDif write SetDetTempMinDif;
    property DetTempMaxDif: TTemperature
      read GetDetTempMaxDif write SetDetTempMaxDif;
    property DetTempDev: TDeviation
      read GetDetTempDev write SetDetTempDev;
    property AAAState: TAAAState
      read GetAAAState write SetAAAState;
    property PumpStartInhibit: boolean
      read GetPumpStartInhibit write SetPumpStartInhibit;
    property RunWhenReady: boolean
      read GetRunWhenReady write SetRunWhenReady;
    property CoolerBlockEnabled: boolean
      read GetCoolerBlockEnabled write SetCoolerBlockEnabled;
  end;

const
  AAAChildRecIDs: array[0..0] of TULRecID = (
    ULIID
  );
  AAAFldDescs: array[0..27] of TULFldDesc = (
    (
     Caption: '';
     Hint: 'Name of the AAA setup';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 2;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AAAName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TAAAName';
    ),
    (
     Caption: 'AAA Desc.';
     Hint: 'Description of the AAA setup';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 2;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AAADesc';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TAAADesc';
    ),
    (
     Caption: 'Sequences directory';
     Hint: 'Directory for new sequence files/directories';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 529441;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SeqsDir';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Programs directory';
     Hint: 'Directory for program files';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 529441;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PrgsDir';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Methods directory';
     Hint: 'Directory for method files';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 529441;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MethodsDir';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Current Sequence';
     Hint: 'File name of the current sequence';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4133;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'Sequences (*.ULS)|*.ULS';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SeqFileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Default Prog.Name';
     Hint: 'Default AA Program file for new sequence';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4133;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'Programs (*.AAP)|*.AAP';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PrgFileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Default mehod for new sequence';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4133;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'Methods (*.ULM)|*.ULM';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MethodFileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'P1 Flow[ml/min]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 1000.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'P1_FLOW';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFlowRate';
    ),
    (
     Caption: 'P1 Press Min[MPa]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 1;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'P1_PRESS_L';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TPressure';
    ),
    (
     Caption: 'P1 Press Max[MPa]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 1;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'P1_PRESS_H';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFlowRate';
    ),
    (
     Caption: 'P1 Deviation[%]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'P1PressDev';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TDeviation';
    ),
    (
     Caption: 'P2 Flow[ml/min]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 1000.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'P2_FLOW';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFlowRate';
    ),
    (
     Caption: 'P2 Press Min[MPa]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 1;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'P2_PRESS_L';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TPressure';
    ),
    (
     Caption: 'P2 Press Max[MPa]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 1;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'P2_PRESS_H';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFlowRate';
    ),
    (
     Caption: 'P2 Deviation[%]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'P2PressDev';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TDeviation';
    ),
    (
     Caption: 'Column Temp.[C]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AS_TEMP1RQ';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TTemperature';
    ),
    (
     Caption: 'Col.Temp.Min-Dif[C]';
     Hint: 'Substracting this from Column.Temp. gives minimal allowed temp.';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AsTempMinDif';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TTemperature';
    ),
    (
     Caption: 'Col.Temp.Max-Dif[C]';
     Hint: 'Adding this to Column.Temp. gives maximal allowed temp.';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AsTempMaxDif';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TTemperature';
    ),
    (
     Caption: 'Column Temp.Dev.[%]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AsTempDev';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TDeviation';
    ),
    (
     Caption: 'React.Temp.[C]';
     Hint: 'Requested temperature in reactor';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DET_TEMP1RQ';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TTemperature';
    ),
    (
     Caption: 'React.Temp.Min-Dif[C]';
     Hint: 'Substracting this from React.Temp. gives minimal allowed temp.';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DetTempMinDif';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TTemperature';
    ),
    (
     Caption: 'React.Temp.Max-Dif[C]';
     Hint: 'Adding this to React.Temp. gives maximal allowed temp.';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 10.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DetTempMaxDif';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TTemperature';
    ),
    (
     Caption: 'React.Temp.Dev.[%]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DetTempDev';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TDeviation';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 2;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AAAState';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TAAAState';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 2;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PumpStartInhibit';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 2;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'RunWhenReady';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'Cooler Control by UPS';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'CoolerBlockEnabled';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    )
  );

  AAARecDesc: TULRecDesc = (
    Caption: 'Amino Acid Analyser';
    ChildRecIDsStr: 'ULIID';
    ChildRecIDs: @AAAChildRecIDs;
    ChildRecIDCount: 1;
    FldCount: 28;
    Flds: @AAAFldDescs;
    Flags: rfChildAllowed OR rfRootChild OR rfHasRecName OR rfEnabled OR rfEditModal OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TAAAObj}
function TAAAObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TAAARec);
end;

constructor TAAAObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), AAAID);
   AAAName := 'AAA';
  P1_FLOW := 300;
  P1_PRESS_L := 10;
  P1_PRESS_H := 70;
  P1PressDev := 10;
  P2_FLOW := 200;
  P2_PRESS_L := 0;
  P2_PRESS_H := 40;
  P2PressDev := 40;
  AS_TEMP1RQ := 500;
  AsTempMinDif := 50;
  AsTempMaxDif := 50;
  AsTempDev := 10;
  DET_TEMP1RQ := 1210;
  DetTempMinDif := 50;
  DetTempMaxDif := 50;
  DetTempDev := 10;
end;

function TAAAObj.GetULRecDesc: PULRecDesc;
begin
  Result := @AAARecDesc;
end;

procedure TAAAObj.SetAAAName(AAAAName: TAAAName);
begin
  if PAAARec(Rec)^.AAAName <> AAAAName then begin
    PAAARec(Rec)^.AAAName := AAAAName;
    if AAAFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetAAAName: TAAAName;
begin
  GetAAAName := PAAARec(Rec)^.AAAName;
end;

procedure TAAAObj.SetAAADesc(AAAADesc: TAAADesc);
begin
  if PAAARec(Rec)^.AAADesc <> AAAADesc then begin
    PAAARec(Rec)^.AAADesc := AAAADesc;
    if AAAFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetAAADesc: TAAADesc;
begin
  GetAAADesc := PAAARec(Rec)^.AAADesc;
end;

procedure TAAAObj.SetSeqsDir(ASeqsDir: string);
begin
  if PAAARec(Rec)^.SeqsDir <> ASeqsDir then begin
    PAAARec(Rec)^.SeqsDir := ASeqsDir;
    if AAAFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetSeqsDir: string;
begin
  GetSeqsDir := PAAARec(Rec)^.SeqsDir;
end;

procedure TAAAObj.SetPrgsDir(APrgsDir: string);
begin
  if PAAARec(Rec)^.PrgsDir <> APrgsDir then begin
    PAAARec(Rec)^.PrgsDir := APrgsDir;
    if AAAFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetPrgsDir: string;
begin
  GetPrgsDir := PAAARec(Rec)^.PrgsDir;
end;

procedure TAAAObj.SetMethodsDir(AMethodsDir: string);
begin
  if PAAARec(Rec)^.MethodsDir <> AMethodsDir then begin
    PAAARec(Rec)^.MethodsDir := AMethodsDir;
    if AAAFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetMethodsDir: string;
begin
  GetMethodsDir := PAAARec(Rec)^.MethodsDir;
end;

procedure TAAAObj.SetSeqFileName(ASeqFileName: string);
begin
  if PAAARec(Rec)^.SeqFileName <> ASeqFileName then begin
    PAAARec(Rec)^.SeqFileName := ASeqFileName;
    if AAAFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetSeqFileName: string;
begin
  GetSeqFileName := PAAARec(Rec)^.SeqFileName;
end;

procedure TAAAObj.SetPrgFileName(APrgFileName: string);
begin
  if PAAARec(Rec)^.PrgFileName <> APrgFileName then begin
    PAAARec(Rec)^.PrgFileName := APrgFileName;
    if AAAFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetPrgFileName: string;
begin
  GetPrgFileName := PAAARec(Rec)^.PrgFileName;
end;

procedure TAAAObj.SetMethodFileName(AMethodFileName: string);
begin
  if PAAARec(Rec)^.MethodFileName <> AMethodFileName then begin
    PAAARec(Rec)^.MethodFileName := AMethodFileName;
    if AAAFldDescs[7].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetMethodFileName: string;
begin
  GetMethodFileName := PAAARec(Rec)^.MethodFileName;
end;

procedure TAAAObj.SetP1_FLOW(AP1_FLOW: TFlowRate);
begin
  if PAAARec(Rec)^.P1_FLOW <> AP1_FLOW then begin
    PAAARec(Rec)^.P1_FLOW := AP1_FLOW;
    if AAAFldDescs[8].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetP1_FLOW: TFlowRate;
begin
  GetP1_FLOW := PAAARec(Rec)^.P1_FLOW;
end;

procedure TAAAObj.SetP1_PRESS_L(AP1_PRESS_L: TPressure);
begin
  if PAAARec(Rec)^.P1_PRESS_L <> AP1_PRESS_L then begin
    PAAARec(Rec)^.P1_PRESS_L := AP1_PRESS_L;
    if AAAFldDescs[9].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetP1_PRESS_L: TPressure;
begin
  GetP1_PRESS_L := PAAARec(Rec)^.P1_PRESS_L;
end;

procedure TAAAObj.SetP1_PRESS_H(AP1_PRESS_H: TFlowRate);
begin
  if PAAARec(Rec)^.P1_PRESS_H <> AP1_PRESS_H then begin
    PAAARec(Rec)^.P1_PRESS_H := AP1_PRESS_H;
    if AAAFldDescs[10].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetP1_PRESS_H: TFlowRate;
begin
  GetP1_PRESS_H := PAAARec(Rec)^.P1_PRESS_H;
end;

procedure TAAAObj.SetP1PressDev(AP1PressDev: TDeviation);
begin
  if PAAARec(Rec)^.P1PressDev <> AP1PressDev then begin
    PAAARec(Rec)^.P1PressDev := AP1PressDev;
    if AAAFldDescs[11].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetP1PressDev: TDeviation;
begin
  GetP1PressDev := PAAARec(Rec)^.P1PressDev;
end;

procedure TAAAObj.SetP2_FLOW(AP2_FLOW: TFlowRate);
begin
  if PAAARec(Rec)^.P2_FLOW <> AP2_FLOW then begin
    PAAARec(Rec)^.P2_FLOW := AP2_FLOW;
    if AAAFldDescs[12].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetP2_FLOW: TFlowRate;
begin
  GetP2_FLOW := PAAARec(Rec)^.P2_FLOW;
end;

procedure TAAAObj.SetP2_PRESS_L(AP2_PRESS_L: TPressure);
begin
  if PAAARec(Rec)^.P2_PRESS_L <> AP2_PRESS_L then begin
    PAAARec(Rec)^.P2_PRESS_L := AP2_PRESS_L;
    if AAAFldDescs[13].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetP2_PRESS_L: TPressure;
begin
  GetP2_PRESS_L := PAAARec(Rec)^.P2_PRESS_L;
end;

procedure TAAAObj.SetP2_PRESS_H(AP2_PRESS_H: TFlowRate);
begin
  if PAAARec(Rec)^.P2_PRESS_H <> AP2_PRESS_H then begin
    PAAARec(Rec)^.P2_PRESS_H := AP2_PRESS_H;
    if AAAFldDescs[14].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetP2_PRESS_H: TFlowRate;
begin
  GetP2_PRESS_H := PAAARec(Rec)^.P2_PRESS_H;
end;

procedure TAAAObj.SetP2PressDev(AP2PressDev: TDeviation);
begin
  if PAAARec(Rec)^.P2PressDev <> AP2PressDev then begin
    PAAARec(Rec)^.P2PressDev := AP2PressDev;
    if AAAFldDescs[15].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetP2PressDev: TDeviation;
begin
  GetP2PressDev := PAAARec(Rec)^.P2PressDev;
end;

procedure TAAAObj.SetAS_TEMP1RQ(AAS_TEMP1RQ: TTemperature);
begin
  if PAAARec(Rec)^.AS_TEMP1RQ <> AAS_TEMP1RQ then begin
    PAAARec(Rec)^.AS_TEMP1RQ := AAS_TEMP1RQ;
    if AAAFldDescs[16].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetAS_TEMP1RQ: TTemperature;
begin
  GetAS_TEMP1RQ := PAAARec(Rec)^.AS_TEMP1RQ;
end;

procedure TAAAObj.SetAsTempMinDif(AAsTempMinDif: TTemperature);
begin
  if PAAARec(Rec)^.AsTempMinDif <> AAsTempMinDif then begin
    PAAARec(Rec)^.AsTempMinDif := AAsTempMinDif;
    if AAAFldDescs[17].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetAsTempMinDif: TTemperature;
begin
  GetAsTempMinDif := PAAARec(Rec)^.AsTempMinDif;
end;

procedure TAAAObj.SetAsTempMaxDif(AAsTempMaxDif: TTemperature);
begin
  if PAAARec(Rec)^.AsTempMaxDif <> AAsTempMaxDif then begin
    PAAARec(Rec)^.AsTempMaxDif := AAsTempMaxDif;
    if AAAFldDescs[18].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetAsTempMaxDif: TTemperature;
begin
  GetAsTempMaxDif := PAAARec(Rec)^.AsTempMaxDif;
end;

procedure TAAAObj.SetAsTempDev(AAsTempDev: TDeviation);
begin
  if PAAARec(Rec)^.AsTempDev <> AAsTempDev then begin
    PAAARec(Rec)^.AsTempDev := AAsTempDev;
    if AAAFldDescs[19].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetAsTempDev: TDeviation;
begin
  GetAsTempDev := PAAARec(Rec)^.AsTempDev;
end;

procedure TAAAObj.SetDET_TEMP1RQ(ADET_TEMP1RQ: TTemperature);
begin
  if PAAARec(Rec)^.DET_TEMP1RQ <> ADET_TEMP1RQ then begin
    PAAARec(Rec)^.DET_TEMP1RQ := ADET_TEMP1RQ;
    if AAAFldDescs[20].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetDET_TEMP1RQ: TTemperature;
begin
  GetDET_TEMP1RQ := PAAARec(Rec)^.DET_TEMP1RQ;
end;

procedure TAAAObj.SetDetTempMinDif(ADetTempMinDif: TTemperature);
begin
  if PAAARec(Rec)^.DetTempMinDif <> ADetTempMinDif then begin
    PAAARec(Rec)^.DetTempMinDif := ADetTempMinDif;
    if AAAFldDescs[21].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetDetTempMinDif: TTemperature;
begin
  GetDetTempMinDif := PAAARec(Rec)^.DetTempMinDif;
end;

procedure TAAAObj.SetDetTempMaxDif(ADetTempMaxDif: TTemperature);
begin
  if PAAARec(Rec)^.DetTempMaxDif <> ADetTempMaxDif then begin
    PAAARec(Rec)^.DetTempMaxDif := ADetTempMaxDif;
    if AAAFldDescs[22].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetDetTempMaxDif: TTemperature;
begin
  GetDetTempMaxDif := PAAARec(Rec)^.DetTempMaxDif;
end;

procedure TAAAObj.SetDetTempDev(ADetTempDev: TDeviation);
begin
  if PAAARec(Rec)^.DetTempDev <> ADetTempDev then begin
    PAAARec(Rec)^.DetTempDev := ADetTempDev;
    if AAAFldDescs[23].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetDetTempDev: TDeviation;
begin
  GetDetTempDev := PAAARec(Rec)^.DetTempDev;
end;

procedure TAAAObj.SetAAAState(AAAAState: TAAAState);
begin
  if PAAARec(Rec)^.AAAState <> AAAAState then begin
    PAAARec(Rec)^.AAAState := AAAAState;
    if AAAFldDescs[24].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetAAAState: TAAAState;
begin
  GetAAAState := PAAARec(Rec)^.AAAState;
end;

procedure TAAAObj.SetPumpStartInhibit(APumpStartInhibit: boolean);
begin
  if PAAARec(Rec)^.PumpStartInhibit <> APumpStartInhibit then begin
    PAAARec(Rec)^.PumpStartInhibit := APumpStartInhibit;
    if AAAFldDescs[25].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetPumpStartInhibit: boolean;
begin
  GetPumpStartInhibit := PAAARec(Rec)^.PumpStartInhibit;
end;

procedure TAAAObj.SetRunWhenReady(ARunWhenReady: boolean);
begin
  if PAAARec(Rec)^.RunWhenReady <> ARunWhenReady then begin
    PAAARec(Rec)^.RunWhenReady := ARunWhenReady;
    if AAAFldDescs[26].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetRunWhenReady: boolean;
begin
  GetRunWhenReady := PAAARec(Rec)^.RunWhenReady;
end;

procedure TAAAObj.SetCoolerBlockEnabled(ACoolerBlockEnabled: boolean);
begin
  if PAAARec(Rec)^.CoolerBlockEnabled <> ACoolerBlockEnabled then begin
    PAAARec(Rec)^.CoolerBlockEnabled := ACoolerBlockEnabled;
    if AAAFldDescs[27].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TAAAObj.GetCoolerBlockEnabled: boolean;
begin
  GetCoolerBlockEnabled := PAAARec(Rec)^.CoolerBlockEnabled;
end;

{/TAAAObj}

end.
