unit LNGObju;
{ Generated by MakeComp 1.03 from LNGTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  LNGTType,
  LNGType;

type
  TLNGObj = class(TULObj)
  protected
    function GetLanguageName: string;
    procedure SetLanguageName(ALanguageName: string);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property LanguageName: string
      read GetLanguageName write SetLanguageName;
  end;

const
  LNGChildRecIDs: array[0..0] of TULRecID = (
    LNGTID
  );
  LNGFldDescs: array[0..0] of TULFldDesc = (
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'LanguageName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    )
  );

  LNGRecDesc: TULRecDesc = (
    Caption: 'Language texts';
    ChildRecIDsStr: 'LNGTID';
    ChildRecIDs: @LNGChildRecIDs;
    ChildRecIDCount: 1;
    FldCount: 1;
    Flds: @LNGFldDescs;
    Flags: rfChildAllowed OR rfRootChild OR rfChildSorted OR rfEnabled OR rfVisible OR rfBrowseOnEdit;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TLNGObj}
function TLNGObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TLNGRec);
end;

constructor TLNGObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), LNGID);
end;

function TLNGObj.GetULRecDesc: PULRecDesc;
begin
  Result := @LNGRecDesc;
end;

procedure TLNGObj.SetLanguageName(ALanguageName: string);
begin
  if PLNGRec(Rec)^.LanguageName <> ALanguageName then begin
    PLNGRec(Rec)^.LanguageName := ALanguageName;
    if LNGFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TLNGObj.GetLanguageName: string;
begin
  GetLanguageName := PLNGRec(Rec)^.LanguageName;
end;

{/TLNGObj}

end.
