unit UCFObju;
{ Generated by MakeComp 1.03 from UCFTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  UCFRType,
  UCFType;

type
  TUCFObj = class(TULObj)
  protected
    function GetDefDir: string;
    procedure SetDefDir(ADefDir: string);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property DefDir: string
      read GetDefDir write SetDefDir;
  end;

const
  UCFChildRecIDs: array[0..0] of TULRecID = (
    UCFRID
  );
  UCFFldDescs: array[0..0] of TULFldDesc = (
    (
     Caption: 'Default dir';
     Hint: 'From what directory were the calibration files taken';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4096;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DefDir';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    )
  );

  UCFRecDesc: TULRecDesc = (
    Caption: 'Files';
    ChildRecIDsStr: 'UCFRID';
    ChildRecIDs: @UCFChildRecIDs;
    ChildRecIDCount: 1;
    FldCount: 1;
    Flds: @UCFFldDescs;
    Flags: rfChildAllowed OR rfChildSorted OR rfEnabled OR rfVisible OR rfBrowseOnEdit OR rfSortedByNumber;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TUCFObj}
function TUCFObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TUCFRec);
end;

constructor TUCFObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), UCFID);
end;

function TUCFObj.GetULRecDesc: PULRecDesc;
begin
  Result := @UCFRecDesc;
end;

procedure TUCFObj.SetDefDir(ADefDir: string);
begin
  if PUCFRec(Rec)^.DefDir <> ADefDir then begin
    PUCFRec(Rec)^.DefDir := ADefDir;
    if UCFFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUCFObj.GetDefDir: string;
begin
  GetDefDir := PUCFRec(Rec)^.DefDir;
end;

{/TUCFObj}

end.
