unit UCPLObju;
{ Generated by MakeComp 1.03 from UCPLTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  UCPLType;

type
  TUCPLObj = class(TULObj)
  protected
    function GetResponse: TResponse;
    procedure SetResponse(AResponse: TResponse);
    function GetAmount: TCompoundAmount;
    procedure SetAmount(AAmount: TCompoundAmount);
    function GetWeight: TWeight;
    procedure SetWeight(AWeight: TWeight);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property Response: TResponse
      read GetResponse write SetResponse;
    property Amount: TCompoundAmount
      read GetAmount write SetAmount;
    property Weight: TWeight
      read GetWeight write SetWeight;
  end;

const
  UCPLFldDescs: array[0..2] of TULFldDesc = (
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Response';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TResponse';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Amount';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TCompoundAmount';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Weight';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TWeight';
    )
  );

  UCPLRecDesc: TULRecDesc = (
    Caption: 'Calib.Peak level';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 3;
    Flds: @UCPLFldDescs;
    Flags: rfEnabled OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TUCPLObj}
function TUCPLObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TUCPLRec);
end;

constructor TUCPLObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), UCPLID);
end;

function TUCPLObj.GetULRecDesc: PULRecDesc;
begin
  Result := @UCPLRecDesc;
end;

procedure TUCPLObj.SetResponse(AResponse: TResponse);
begin
  if PUCPLRec(Rec)^.Response <> AResponse then begin
    PUCPLRec(Rec)^.Response := AResponse;
    if UCPLFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUCPLObj.GetResponse: TResponse;
begin
  GetResponse := PUCPLRec(Rec)^.Response;
end;

procedure TUCPLObj.SetAmount(AAmount: TCompoundAmount);
begin
  if PUCPLRec(Rec)^.Amount <> AAmount then begin
    PUCPLRec(Rec)^.Amount := AAmount;
    if UCPLFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUCPLObj.GetAmount: TCompoundAmount;
begin
  GetAmount := PUCPLRec(Rec)^.Amount;
end;

procedure TUCPLObj.SetWeight(AWeight: TWeight);
begin
  if PUCPLRec(Rec)^.Weight <> AWeight then begin
    PUCPLRec(Rec)^.Weight := AWeight;
    if UCPLFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUCPLObj.GetWeight: TWeight;
begin
  GetWeight := PUCPLRec(Rec)^.Weight;
end;

{/TUCPLObj}

end.
