unit UDIRObju;
{ Generated by MakeComp 1.03 from UDIRTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  UDIRType;

type
  TUDIRObj = class(TULObj)
  protected
    function GetDataDir: shortstring;
    procedure SetDataDir(ADataDir: shortstring);
    function GetMethodDir: shortstring;
    procedure SetMethodDir(AMethodDir: shortstring);
    function GetSequenceDir: shortstring;
    procedure SetSequenceDir(ASequenceDir: shortstring);
    function GetPrgDir: shortstring;
    procedure SetPrgDir(APrgDir: shortstring);
    function GetScriptPath: shortstring;
    procedure SetScriptPath(AScriptPath: shortstring);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property DataDir: shortstring
      read GetDataDir write SetDataDir;
    property MethodDir: shortstring
      read GetMethodDir write SetMethodDir;
    property SequenceDir: shortstring
      read GetSequenceDir write SetSequenceDir;
    property PrgDir: shortstring
      read GetPrgDir write SetPrgDir;
    property ScriptPath: shortstring
      read GetScriptPath write SetScriptPath;
  end;

const
  UDIRFldDescs: array[0..4] of TULFldDesc = (
    (
     Caption: '';
     Hint: 'Root data directory, if not specified %EXEDIR%DATA\ used';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 5153;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DataDir';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'shortstring';
    ),
    (
     Caption: '';
     Hint: 'Directory for methods, if not specified %DATADIR%Methods\ used';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 5153;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MethodDir';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'shortstring';
    ),
    (
     Caption: '';
     Hint: 'Directory for sequences, if not specified %DATADIR%Sequences\ used';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 5153;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SequenceDir';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'shortstring';
    ),
    (
     Caption: '';
     Hint: 'Directory for programs, if not specified %DATADIR%Programs\ used';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 5153;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PrgDir';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'shortstring';
    ),
    (
     Caption: '';
     Hint: 'List of script directories, if not specified %DATADIR%Scripts\ used';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 5153;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ScriptPath';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'shortstring';
    )
  );

  UDIRRecDesc: TULRecDesc = (
    Caption: 'Directories';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 5;
    Flds: @UDIRFldDescs;
    Flags: 0;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TUDIRObj}
function TUDIRObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TUDIRRec);
end;

constructor TUDIRObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), UDIRID);
end;

function TUDIRObj.GetULRecDesc: PULRecDesc;
begin
  Result := @UDIRRecDesc;
end;

procedure TUDIRObj.SetDataDir(ADataDir: shortstring);
begin
  if PUDIRRec(Rec)^.DataDir <> ADataDir then begin
    PUDIRRec(Rec)^.DataDir := ADataDir;
    if UDIRFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDIRObj.GetDataDir: shortstring;
begin
  GetDataDir := PUDIRRec(Rec)^.DataDir;
end;

procedure TUDIRObj.SetMethodDir(AMethodDir: shortstring);
begin
  if PUDIRRec(Rec)^.MethodDir <> AMethodDir then begin
    PUDIRRec(Rec)^.MethodDir := AMethodDir;
    if UDIRFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDIRObj.GetMethodDir: shortstring;
begin
  GetMethodDir := PUDIRRec(Rec)^.MethodDir;
end;

procedure TUDIRObj.SetSequenceDir(ASequenceDir: shortstring);
begin
  if PUDIRRec(Rec)^.SequenceDir <> ASequenceDir then begin
    PUDIRRec(Rec)^.SequenceDir := ASequenceDir;
    if UDIRFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDIRObj.GetSequenceDir: shortstring;
begin
  GetSequenceDir := PUDIRRec(Rec)^.SequenceDir;
end;

procedure TUDIRObj.SetPrgDir(APrgDir: shortstring);
begin
  if PUDIRRec(Rec)^.PrgDir <> APrgDir then begin
    PUDIRRec(Rec)^.PrgDir := APrgDir;
    if UDIRFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDIRObj.GetPrgDir: shortstring;
begin
  GetPrgDir := PUDIRRec(Rec)^.PrgDir;
end;

procedure TUDIRObj.SetScriptPath(AScriptPath: shortstring);
begin
  if PUDIRRec(Rec)^.ScriptPath <> AScriptPath then begin
    PUDIRRec(Rec)^.ScriptPath := AScriptPath;
    if UDIRFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDIRObj.GetScriptPath: shortstring;
begin
  GetScriptPath := PUDIRRec(Rec)^.ScriptPath;
end;

{/TUDIRObj}

end.
