unit UDLRObju;
{ Generated by MakeComp 1.03 from UDLRTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULDType,ULDRType,
  UDLRType;

type
  TUDLRObj = class(TULObj)
  protected
    function GetDataName: string;
    procedure SetDataName(ADataName: string);
    function GetColor: integer;
    procedure SetColor(AColor: integer);
    function GetPropDesc: string;
    procedure SetPropDesc(APropDesc: string);
    function GetSamplingInterval: single;
    procedure SetSamplingInterval(ASamplingInterval: single);
    function GetSamplingKind: TSamplingKind;
    procedure SetSamplingKind(ASamplingKind: TSamplingKind);
    function GetDeviceName: string;
    procedure SetDeviceName(ADeviceName: string);
    function GetPointTimeInterval: single;
    procedure SetPointTimeInterval(APointTimeInterval: single);
    function GetMultiplyY: TYValue;
    procedure SetMultiplyY(AMultiplyY: TYValue);
    function GetAddY: TYValue;
    procedure SetAddY(AAddY: TYValue);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property DataName: string
      read GetDataName write SetDataName;
    property Color: integer
      read GetColor write SetColor;
    property PropDesc: string
      read GetPropDesc write SetPropDesc;
    property SamplingInterval: single
      read GetSamplingInterval write SetSamplingInterval;
    property SamplingKind: TSamplingKind
      read GetSamplingKind write SetSamplingKind;
    property DeviceName: string
      read GetDeviceName write SetDeviceName;
    property PointTimeInterval: single
      read GetPointTimeInterval write SetPointTimeInterval;
    property MultiplyY: TYValue
      read GetMultiplyY write SetMultiplyY;
    property AddY: TYValue
      read GetAddY write SetAddY;
  end;

const
  UDLRFldDescs: array[0..8] of TULFldDesc = (
    (
     Caption: 'Data Line Name';
     Hint: 'User defined name of this data line';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DataName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 266273;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Color';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'integer';
    ),
    (
     Caption: 'Prop.Name';
     Hint: 'Name of the property the value of that should be acquired';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4113;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: ULDRID;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PropDesc';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Sampling Interval[s]';
     Hint: 'How often ask for the value of Prop.Name property';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SamplingInterval';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'single';
    ),
    (
     Caption: 'Sampling Kind';
     Hint: 'How to take samples - poll or scan packets';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SamplingKind';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSamplingKind';
    ),
    (
     Caption: '';
     Hint: 'Name of the device (if any), which property should be scanned';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4113;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: ULDID;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DeviceName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Point interval[ms]';
     Hint: 'Interval of data points in packets';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PointTimeInterval';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'single';
    ),
    (
     Caption: '';
     Hint: 'Acquired Y value multiply by this before storing to file';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MultiplyY';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TYValue';
    ),
    (
     Caption: '';
     Hint: 'Add to acquired Y value before storing to file';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AddY';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TYValue';
    )
  );

  UDLRRecDesc: TULRecDesc = (
    Caption: 'Raw Data Def.';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 9;
    Flds: @UDLRFldDescs;
    Flags: rfChildAllowed OR rfDataChild OR rfHasPointer OR rfUsingColors OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: 'DataName,Color,DeviceName,PropDesc,SamplingInterval,SamplingKind';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: 'DataName';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TUDLRObj}
function TUDLRObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TUDLRRec);
end;

constructor TUDLRObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), UDLRID);
  Color := clBlue;
  PointTimeInterval := 40;
  MultiplyY := 1;
end;

function TUDLRObj.GetULRecDesc: PULRecDesc;
begin
  Result := @UDLRRecDesc;
end;

procedure TUDLRObj.SetDataName(ADataName: string);
begin
  if PUDLRRec(Rec)^.DataName <> ADataName then begin
    PUDLRRec(Rec)^.DataName := ADataName;
    if UDLRFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDLRObj.GetDataName: string;
begin
  GetDataName := PUDLRRec(Rec)^.DataName;
end;

procedure TUDLRObj.SetColor(AColor: integer);
begin
  if PUDLRRec(Rec)^.Color <> AColor then begin
    PUDLRRec(Rec)^.Color := AColor;
    if UDLRFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDLRObj.GetColor: integer;
begin
  GetColor := PUDLRRec(Rec)^.Color;
end;

procedure TUDLRObj.SetPropDesc(APropDesc: string);
begin
  if PUDLRRec(Rec)^.PropDesc <> APropDesc then begin
    PUDLRRec(Rec)^.PropDesc := APropDesc;
    if UDLRFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDLRObj.GetPropDesc: string;
begin
  GetPropDesc := PUDLRRec(Rec)^.PropDesc;
end;

procedure TUDLRObj.SetSamplingInterval(ASamplingInterval: single);
begin
  if PUDLRRec(Rec)^.SamplingInterval <> ASamplingInterval then begin
    PUDLRRec(Rec)^.SamplingInterval := ASamplingInterval;
    if UDLRFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDLRObj.GetSamplingInterval: single;
begin
  GetSamplingInterval := PUDLRRec(Rec)^.SamplingInterval;
end;

procedure TUDLRObj.SetSamplingKind(ASamplingKind: TSamplingKind);
begin
  if PUDLRRec(Rec)^.SamplingKind <> ASamplingKind then begin
    PUDLRRec(Rec)^.SamplingKind := ASamplingKind;
    if UDLRFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDLRObj.GetSamplingKind: TSamplingKind;
begin
  GetSamplingKind := PUDLRRec(Rec)^.SamplingKind;
end;

procedure TUDLRObj.SetDeviceName(ADeviceName: string);
begin
  if PUDLRRec(Rec)^.DeviceName <> ADeviceName then begin
    PUDLRRec(Rec)^.DeviceName := ADeviceName;
    if UDLRFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDLRObj.GetDeviceName: string;
begin
  GetDeviceName := PUDLRRec(Rec)^.DeviceName;
end;

procedure TUDLRObj.SetPointTimeInterval(APointTimeInterval: single);
begin
  if PUDLRRec(Rec)^.PointTimeInterval <> APointTimeInterval then begin
    PUDLRRec(Rec)^.PointTimeInterval := APointTimeInterval;
    if UDLRFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDLRObj.GetPointTimeInterval: single;
begin
  GetPointTimeInterval := PUDLRRec(Rec)^.PointTimeInterval;
end;

procedure TUDLRObj.SetMultiplyY(AMultiplyY: TYValue);
begin
  if PUDLRRec(Rec)^.MultiplyY <> AMultiplyY then begin
    PUDLRRec(Rec)^.MultiplyY := AMultiplyY;
    if UDLRFldDescs[7].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDLRObj.GetMultiplyY: TYValue;
begin
  GetMultiplyY := PUDLRRec(Rec)^.MultiplyY;
end;

procedure TUDLRObj.SetAddY(AAddY: TYValue);
begin
  if PUDLRRec(Rec)^.AddY <> AAddY then begin
    PUDLRRec(Rec)^.AddY := AAddY;
    if UDLRFldDescs[8].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUDLRObj.GetAddY: TYValue;
begin
  GetAddY := PUDLRRec(Rec)^.AddY;
end;

{/TUDLRObj}

end.
