unit ULADObju;
{ Generated by MakeComp 1.03 from ULADTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULDType,ULDRType,
  ULADType;

type
  TULADObj = class(TULObj)
  protected
    function GetDataName: string;
    procedure SetDataName(ADataName: string);
    function GetColor: integer;
    procedure SetColor(AColor: integer);
    function GetPropDesc: string;
    procedure SetPropDesc(APropDesc: string);
    function GetSamplingInterval: single;
    procedure SetSamplingInterval(ASamplingInterval: single);
    function GetSamplingKind: TSamplingKind;
    procedure SetSamplingKind(ASamplingKind: TSamplingKind);
    function GetDeviceName: string;
    procedure SetDeviceName(ADeviceName: string);
    function GetPointTimeInterval: single;
    procedure SetPointTimeInterval(APointTimeInterval: single);
    function GetAddr: integer;
    procedure SetAddr(AAddr: integer);
    function GetMultiplyY: TYValue;
    procedure SetMultiplyY(AMultiplyY: TYValue);
    function GetAddY: TYValue;
    procedure SetAddY(AAddY: TYValue);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property DataName: string
      read GetDataName write SetDataName;
    property Color: integer
      read GetColor write SetColor;
    property PropDesc: string
      read GetPropDesc write SetPropDesc;
    property SamplingInterval: single
      read GetSamplingInterval write SetSamplingInterval;
    property SamplingKind: TSamplingKind
      read GetSamplingKind write SetSamplingKind;
    property DeviceName: string
      read GetDeviceName write SetDeviceName;
    property PointTimeInterval: single
      read GetPointTimeInterval write SetPointTimeInterval;
    property Addr: integer
      read GetAddr write SetAddr;
    property MultiplyY: TYValue
      read GetMultiplyY write SetMultiplyY;
    property AddY: TYValue
      read GetAddY write SetAddY;
  end;

const
  ULADFldDescs: array[0..9] of TULFldDesc = (
    (
     Caption: 'Data Line Name';
     Hint: 'User defined name of this data line';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DataName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 266272;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Color';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'integer';
    ),
    (
     Caption: 'Prop.Name';
     Hint: 'Name of the property the value of that should be aquired';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4113;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: ULDRID;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PropDesc';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Sampling Interval[s]';
     Hint: 'How often ask for the value of Prop.Name property';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SamplingInterval';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'single';
    ),
    (
     Caption: 'Sampling Kind';
     Hint: 'How to take samples - poll or scan packets';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SamplingKind';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSamplingKind';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4113;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: ULDID;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DeviceName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Point interval[ms]';
     Hint: 'Interval of data points in packets';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PointTimeInterval';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'single';
    ),
    (
     Caption: '';
     Hint: 'What was the uLan network address of the DeviceName';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4096;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Addr';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'integer';
    ),
    (
     Caption: '';
     Hint: 'Acquired Y value multiply by this before storing to file';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MultiplyY';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TYValue';
    ),
    (
     Caption: '';
     Hint: 'Add to acquired Y value before storing to file';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AddY';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TYValue';
    )
  );

  ULADRecDesc: TULRecDesc = (
    Caption: 'Raw Data';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 10;
    Flds: @ULADFldDescs;
    Flags: rfChildAllowed OR rfDataChild OR rfHasPointer OR rfUsingColors;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: 'DataName';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TULADObj}
function TULADObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULADRec);
end;

constructor TULADObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULADID);
  MultiplyY := 1;
end;

function TULADObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULADRecDesc;
end;

procedure TULADObj.SetDataName(ADataName: string);
begin
  if PULADRec(Rec)^.DataName <> ADataName then begin
    PULADRec(Rec)^.DataName := ADataName;
    if ULADFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetDataName: string;
begin
  GetDataName := PULADRec(Rec)^.DataName;
end;

procedure TULADObj.SetColor(AColor: integer);
begin
  if PULADRec(Rec)^.Color <> AColor then begin
    PULADRec(Rec)^.Color := AColor;
    if ULADFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetColor: integer;
begin
  GetColor := PULADRec(Rec)^.Color;
end;

procedure TULADObj.SetPropDesc(APropDesc: string);
begin
  if PULADRec(Rec)^.PropDesc <> APropDesc then begin
    PULADRec(Rec)^.PropDesc := APropDesc;
    if ULADFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetPropDesc: string;
begin
  GetPropDesc := PULADRec(Rec)^.PropDesc;
end;

procedure TULADObj.SetSamplingInterval(ASamplingInterval: single);
begin
  if PULADRec(Rec)^.SamplingInterval <> ASamplingInterval then begin
    PULADRec(Rec)^.SamplingInterval := ASamplingInterval;
    if ULADFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetSamplingInterval: single;
begin
  GetSamplingInterval := PULADRec(Rec)^.SamplingInterval;
end;

procedure TULADObj.SetSamplingKind(ASamplingKind: TSamplingKind);
begin
  if PULADRec(Rec)^.SamplingKind <> ASamplingKind then begin
    PULADRec(Rec)^.SamplingKind := ASamplingKind;
    if ULADFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetSamplingKind: TSamplingKind;
begin
  GetSamplingKind := PULADRec(Rec)^.SamplingKind;
end;

procedure TULADObj.SetDeviceName(ADeviceName: string);
begin
  if PULADRec(Rec)^.DeviceName <> ADeviceName then begin
    PULADRec(Rec)^.DeviceName := ADeviceName;
    if ULADFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetDeviceName: string;
begin
  GetDeviceName := PULADRec(Rec)^.DeviceName;
end;

procedure TULADObj.SetPointTimeInterval(APointTimeInterval: single);
begin
  if PULADRec(Rec)^.PointTimeInterval <> APointTimeInterval then begin
    PULADRec(Rec)^.PointTimeInterval := APointTimeInterval;
    if ULADFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetPointTimeInterval: single;
begin
  GetPointTimeInterval := PULADRec(Rec)^.PointTimeInterval;
end;

procedure TULADObj.SetAddr(AAddr: integer);
begin
  if PULADRec(Rec)^.Addr <> AAddr then begin
    PULADRec(Rec)^.Addr := AAddr;
    if ULADFldDescs[7].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetAddr: integer;
begin
  GetAddr := PULADRec(Rec)^.Addr;
end;

procedure TULADObj.SetMultiplyY(AMultiplyY: TYValue);
begin
  if PULADRec(Rec)^.MultiplyY <> AMultiplyY then begin
    PULADRec(Rec)^.MultiplyY := AMultiplyY;
    if ULADFldDescs[8].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetMultiplyY: TYValue;
begin
  GetMultiplyY := PULADRec(Rec)^.MultiplyY;
end;

procedure TULADObj.SetAddY(AAddY: TYValue);
begin
  if PULADRec(Rec)^.AddY <> AAddY then begin
    PULADRec(Rec)^.AddY := AAddY;
    if ULADFldDescs[9].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULADObj.GetAddY: TYValue;
begin
  GetAddY := PULADRec(Rec)^.AddY;
end;

{/TULADObj}

end.
