unit ULAObju;
{ Generated by MakeComp 1.03 from ULATYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULADType,ULAFType,ULIType,ULMType,UDVSType,ULVType,UCPType,AAPGType,
  ULAType;

type
  TULAObj = class(TULObj)
  protected
    function GetSampleName: TSampleName;
    procedure SetSampleName(ASampleName: TSampleName);
    function GetSampleDesc: TSampleDesc;
    procedure SetSampleDesc(ASampleDesc: TSampleDesc);
    function GetAmount: TSampleAmount;
    procedure SetAmount(AAmount: TSampleAmount);
    function GetISTDAmount: TSampleAmount;
    procedure SetISTDAmount(AISTDAmount: TSampleAmount);
    function GetInjectionVolume: TInjectionVolume;
    procedure SetInjectionVolume(AInjectionVolume: TInjectionVolume);
    function GetCalibrationStandard: boolean;
    procedure SetCalibrationStandard(ACalibrationStandard: boolean);
    function GetExternalStartEnabled: boolean;
    procedure SetExternalStartEnabled(AExternalStartEnabled: boolean);
    function GetUserID: TUserID;
    procedure SetUserID(AUserID: TUserID);
    function GetUserName: TUserName;
    procedure SetUserName(AUserName: TUserName);
    function GetMultiplyFactor: TFactor;
    procedure SetMultiplyFactor(AMultiplyFactor: TFactor);
    function GetDateTime: longint;
    procedure SetDateTime(ADateTime: longint);
    function GetDivideFactor: TFactor;
    procedure SetDivideFactor(ADivideFactor: TFactor);
    function GetAutodetectLater: boolean;
    procedure SetAutodetectLater(AAutodetectLater: boolean);
    function GetTemplateFileName: string;
    procedure SetTemplateFileName(ATemplateFileName: string);
    function GetVialNr: integer;
    procedure SetVialNr(AVialNr: integer);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property SampleName: TSampleName
      read GetSampleName write SetSampleName;
    property SampleDesc: TSampleDesc
      read GetSampleDesc write SetSampleDesc;
    property Amount: TSampleAmount
      read GetAmount write SetAmount;
    property ISTDAmount: TSampleAmount
      read GetISTDAmount write SetISTDAmount;
    property InjectionVolume: TInjectionVolume
      read GetInjectionVolume write SetInjectionVolume;
    property CalibrationStandard: boolean
      read GetCalibrationStandard write SetCalibrationStandard;
    property ExternalStartEnabled: boolean
      read GetExternalStartEnabled write SetExternalStartEnabled;
    property UserID: TUserID
      read GetUserID write SetUserID;
    property UserName: TUserName
      read GetUserName write SetUserName;
    property MultiplyFactor: TFactor
      read GetMultiplyFactor write SetMultiplyFactor;
    property DateTime: longint
      read GetDateTime write SetDateTime;
    property DivideFactor: TFactor
      read GetDivideFactor write SetDivideFactor;
    property AutodetectLater: boolean
      read GetAutodetectLater write SetAutodetectLater;
    property TemplateFileName: string
      read GetTemplateFileName write SetTemplateFileName;
    property VialNr: integer
      read GetVialNr write SetVialNr;
  end;

const
  ULAChildRecIDs: array[0..7] of TULRecID = (
    ULADID,ULAFID,ULIID,ULMID,UDVSID,ULVID,UCPID,AAPGID
  );
  ULAFldDescs: array[0..14] of TULFldDesc = (
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SampleName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSampleName';
    ),
    (
     Caption: 'Sample Desc.';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SampleDesc';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSampleDesc';
    ),
    (
     Caption: '';
     Hint: 'Note about what amount of the sample used';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Amount';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSampleAmount';
    ),
    (
     Caption: '';
     Hint: 'What is the amount of ISTD (used if not specified at ISTD peak)';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ISTDAmount';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSampleAmount';
    ),
    (
     Caption: 'Inj.volume[ul]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'InjectionVolume';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TInjectionVolume';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'CalibrationStandard';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ExternalStartEnabled';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'UserID';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TUserID';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'UserName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TUserName';
    ),
    (
     Caption: '';
     Hint: 'Used to multiply peak results with';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MultiplyFactor';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFactor';
    ),
    (
     Caption: 'Date,Time';
     Hint: 'Date/Time when was the acquisition finished';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4105;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DateTime';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'longint';
    ),
    (
     Caption: '';
     Hint: 'Used to divide peak results with';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DivideFactor';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFactor';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 3;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AutodetectLater';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'Template file name';
     Hint: 'Name of template file (used for data acquisition and evaluation)';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4133;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'Template (*.ULT)|*.ULT';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'TemplateFileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Vial Nr.';
     Hint: 'Number of the sample position in the autosampler at the time of acquisition';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'VialNr';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'integer';
    )
  );

  ULARecDesc: TULRecDesc = (
    Caption: 'Sample';
    ChildRecIDsStr: 'ULADID,ULAFID,ULIID,ULMID,UDVSID,ULVID,UCPID,AAPGID';
    ChildRecIDs: @ULAChildRecIDs;
    ChildRecIDCount: 8;
    FldCount: 15;
    Flds: @ULAFldDescs;
    Flags: rfChildAllowed OR rfRootChild OR rfHasRecName OR rfAskForSave OR rfEnabled OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: 'uLan file (*.ULF)|*.ULF|Raw data (*.DAT)|*.DAT|All files (*.*)|*.*|Raw ASCII data  (*.TXT)|*.TXT|uLan ASCII file (*.ASC)|*.ASC|Micro AAA (*.G;*.B)|*.G;*.B|Template (*.ULT)|*.ULT|Mikro AAA (*.HEA)|*.HEA';
    SaveFilter: 'uLan Analysis File (*.ULF)|*.ULF|Raw Data (*.DAT)|*.DAT|Raw ASCII (*.TXT)|*.TXT|uLan Analysis ASCII (*.ASC)|*.ASC|uLan Analysis Template (*.ULT)|*.ULT';
    Table: '';
    Indexes: ''
   );

implementation

{TULAObj}
function TULAObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULARec);
end;

constructor TULAObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULAID);
  MultiplyFactor := 1;
  DivideFactor := 1;
end;

function TULAObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULARecDesc;
end;

procedure TULAObj.SetSampleName(ASampleName: TSampleName);
begin
  if PULARec(Rec)^.SampleName <> ASampleName then begin
    PULARec(Rec)^.SampleName := ASampleName;
    if ULAFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetSampleName: TSampleName;
begin
  GetSampleName := PULARec(Rec)^.SampleName;
end;

procedure TULAObj.SetSampleDesc(ASampleDesc: TSampleDesc);
begin
  if PULARec(Rec)^.SampleDesc <> ASampleDesc then begin
    PULARec(Rec)^.SampleDesc := ASampleDesc;
    if ULAFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetSampleDesc: TSampleDesc;
begin
  GetSampleDesc := PULARec(Rec)^.SampleDesc;
end;

procedure TULAObj.SetAmount(AAmount: TSampleAmount);
begin
  if PULARec(Rec)^.Amount <> AAmount then begin
    PULARec(Rec)^.Amount := AAmount;
    if ULAFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetAmount: TSampleAmount;
begin
  GetAmount := PULARec(Rec)^.Amount;
end;

procedure TULAObj.SetISTDAmount(AISTDAmount: TSampleAmount);
begin
  if PULARec(Rec)^.ISTDAmount <> AISTDAmount then begin
    PULARec(Rec)^.ISTDAmount := AISTDAmount;
    if ULAFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetISTDAmount: TSampleAmount;
begin
  GetISTDAmount := PULARec(Rec)^.ISTDAmount;
end;

procedure TULAObj.SetInjectionVolume(AInjectionVolume: TInjectionVolume);
begin
  if PULARec(Rec)^.InjectionVolume <> AInjectionVolume then begin
    PULARec(Rec)^.InjectionVolume := AInjectionVolume;
    if ULAFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetInjectionVolume: TInjectionVolume;
begin
  GetInjectionVolume := PULARec(Rec)^.InjectionVolume;
end;

procedure TULAObj.SetCalibrationStandard(ACalibrationStandard: boolean);
begin
  if PULARec(Rec)^.CalibrationStandard <> ACalibrationStandard then begin
    PULARec(Rec)^.CalibrationStandard := ACalibrationStandard;
    if ULAFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetCalibrationStandard: boolean;
begin
  GetCalibrationStandard := PULARec(Rec)^.CalibrationStandard;
end;

procedure TULAObj.SetExternalStartEnabled(AExternalStartEnabled: boolean);
begin
  if PULARec(Rec)^.ExternalStartEnabled <> AExternalStartEnabled then begin
    PULARec(Rec)^.ExternalStartEnabled := AExternalStartEnabled;
    if ULAFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetExternalStartEnabled: boolean;
begin
  GetExternalStartEnabled := PULARec(Rec)^.ExternalStartEnabled;
end;

procedure TULAObj.SetUserID(AUserID: TUserID);
begin
  if PULARec(Rec)^.UserID <> AUserID then begin
    PULARec(Rec)^.UserID := AUserID;
    if ULAFldDescs[7].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetUserID: TUserID;
begin
  GetUserID := PULARec(Rec)^.UserID;
end;

procedure TULAObj.SetUserName(AUserName: TUserName);
begin
  if PULARec(Rec)^.UserName <> AUserName then begin
    PULARec(Rec)^.UserName := AUserName;
    if ULAFldDescs[8].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetUserName: TUserName;
begin
  GetUserName := PULARec(Rec)^.UserName;
end;

procedure TULAObj.SetMultiplyFactor(AMultiplyFactor: TFactor);
begin
  if PULARec(Rec)^.MultiplyFactor <> AMultiplyFactor then begin
    PULARec(Rec)^.MultiplyFactor := AMultiplyFactor;
    if ULAFldDescs[9].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetMultiplyFactor: TFactor;
begin
  GetMultiplyFactor := PULARec(Rec)^.MultiplyFactor;
end;

procedure TULAObj.SetDateTime(ADateTime: longint);
begin
  if PULARec(Rec)^.DateTime <> ADateTime then begin
    PULARec(Rec)^.DateTime := ADateTime;
    if ULAFldDescs[10].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetDateTime: longint;
begin
  GetDateTime := PULARec(Rec)^.DateTime;
end;

procedure TULAObj.SetDivideFactor(ADivideFactor: TFactor);
begin
  if PULARec(Rec)^.DivideFactor <> ADivideFactor then begin
    PULARec(Rec)^.DivideFactor := ADivideFactor;
    if ULAFldDescs[11].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetDivideFactor: TFactor;
begin
  GetDivideFactor := PULARec(Rec)^.DivideFactor;
end;

procedure TULAObj.SetAutodetectLater(AAutodetectLater: boolean);
begin
  if PULARec(Rec)^.AutodetectLater <> AAutodetectLater then begin
    PULARec(Rec)^.AutodetectLater := AAutodetectLater;
    if ULAFldDescs[12].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetAutodetectLater: boolean;
begin
  GetAutodetectLater := PULARec(Rec)^.AutodetectLater;
end;

procedure TULAObj.SetTemplateFileName(ATemplateFileName: string);
begin
  if PULARec(Rec)^.TemplateFileName <> ATemplateFileName then begin
    PULARec(Rec)^.TemplateFileName := ATemplateFileName;
    if ULAFldDescs[13].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetTemplateFileName: string;
begin
  GetTemplateFileName := PULARec(Rec)^.TemplateFileName;
end;

procedure TULAObj.SetVialNr(AVialNr: integer);
begin
  if PULARec(Rec)^.VialNr <> AVialNr then begin
    PULARec(Rec)^.VialNr := AVialNr;
    if ULAFldDescs[14].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULAObj.GetVialNr: integer;
begin
  GetVialNr := PULARec(Rec)^.VialNr;
end;

{/TULAObj}

end.
