unit ULCObju;
{ Generated by MakeComp 1.03 from ULCTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  UCPType,UCFType,
  ULCType;

type
  TULCObj = class(TULObj)
  protected
    function GetCalibName: TSampleName;
    procedure SetCalibName(ACalibName: TSampleName);
    function GetCalibDesc: TSampleDesc;
    procedure SetCalibDesc(ACalibDesc: TSampleDesc);
    function GetUserID: TUserID;
    procedure SetUserID(AUserID: TUserID);
    function GetUserName: TUserName;
    procedure SetUserName(AUserName: TUserName);
    function GetDateTime: longint;
    procedure SetDateTime(ADateTime: longint);
    function GetCalibType: TCalibType;
    procedure SetCalibType(ACalibType: TCalibType);
    function GetPeakFindKind: TPeakFindKind;
    procedure SetPeakFindKind(APeakFindKind: TPeakFindKind);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property CalibName: TSampleName
      read GetCalibName write SetCalibName;
    property CalibDesc: TSampleDesc
      read GetCalibDesc write SetCalibDesc;
    property UserID: TUserID
      read GetUserID write SetUserID;
    property UserName: TUserName
      read GetUserName write SetUserName;
    property DateTime: longint
      read GetDateTime write SetDateTime;
    property CalibType: TCalibType
      read GetCalibType write SetCalibType;
    property PeakFindKind: TPeakFindKind
      read GetPeakFindKind write SetPeakFindKind;
  end;

const
  ULCChildRecIDs: array[0..1] of TULRecID = (
    UCPID,UCFID
  );
  ULCFldDescs: array[0..6] of TULFldDesc = (
    (
     Caption: 'Calib. Name';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'CalibName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSampleName';
    ),
    (
     Caption: 'Calib. Desc.';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'CalibDesc';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSampleDesc';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'UserID';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TUserID';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'UserName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TUserName';
    ),
    (
     Caption: 'Date,Time';
     Hint: 'Date/Time when was the acquisition finished';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4105;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DateTime';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'longint';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4096;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'CalibType';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TCalibType';
    ),
    (
     Caption: '';
     Hint: 'Composed peaks created either from each peak in any file (OR) or only from peaks found in each file (AND)';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4096;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PeakFindKind';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TPeakFindKind';
    )
  );

  ULCRecDesc: TULRecDesc = (
    Caption: 'Calibration';
    ChildRecIDsStr: 'UCPID,UCFID';
    ChildRecIDs: @ULCChildRecIDs;
    ChildRecIDCount: 2;
    FldCount: 7;
    Flds: @ULCFldDescs;
    Flags: rfChildAllowed OR rfRootChild OR rfHasRecName OR rfAskForSave OR rfEnabled OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: 'Calibration file (*.ULC)|*.ULC';
    SaveFilter: 'Calibration file (*.ULC)|*.ULC';
    Table: '';
    Indexes: ''
   );

implementation

{TULCObj}
function TULCObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULCRec);
end;

constructor TULCObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULCID);
end;

function TULCObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULCRecDesc;
end;

procedure TULCObj.SetCalibName(ACalibName: TSampleName);
begin
  if PULCRec(Rec)^.CalibName <> ACalibName then begin
    PULCRec(Rec)^.CalibName := ACalibName;
    if ULCFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULCObj.GetCalibName: TSampleName;
begin
  GetCalibName := PULCRec(Rec)^.CalibName;
end;

procedure TULCObj.SetCalibDesc(ACalibDesc: TSampleDesc);
begin
  if PULCRec(Rec)^.CalibDesc <> ACalibDesc then begin
    PULCRec(Rec)^.CalibDesc := ACalibDesc;
    if ULCFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULCObj.GetCalibDesc: TSampleDesc;
begin
  GetCalibDesc := PULCRec(Rec)^.CalibDesc;
end;

procedure TULCObj.SetUserID(AUserID: TUserID);
begin
  if PULCRec(Rec)^.UserID <> AUserID then begin
    PULCRec(Rec)^.UserID := AUserID;
    if ULCFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULCObj.GetUserID: TUserID;
begin
  GetUserID := PULCRec(Rec)^.UserID;
end;

procedure TULCObj.SetUserName(AUserName: TUserName);
begin
  if PULCRec(Rec)^.UserName <> AUserName then begin
    PULCRec(Rec)^.UserName := AUserName;
    if ULCFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULCObj.GetUserName: TUserName;
begin
  GetUserName := PULCRec(Rec)^.UserName;
end;

procedure TULCObj.SetDateTime(ADateTime: longint);
begin
  if PULCRec(Rec)^.DateTime <> ADateTime then begin
    PULCRec(Rec)^.DateTime := ADateTime;
    if ULCFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULCObj.GetDateTime: longint;
begin
  GetDateTime := PULCRec(Rec)^.DateTime;
end;

procedure TULCObj.SetCalibType(ACalibType: TCalibType);
begin
  if PULCRec(Rec)^.CalibType <> ACalibType then begin
    PULCRec(Rec)^.CalibType := ACalibType;
    if ULCFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULCObj.GetCalibType: TCalibType;
begin
  GetCalibType := PULCRec(Rec)^.CalibType;
end;

procedure TULCObj.SetPeakFindKind(APeakFindKind: TPeakFindKind);
begin
  if PULCRec(Rec)^.PeakFindKind <> APeakFindKind then begin
    PULCRec(Rec)^.PeakFindKind := APeakFindKind;
    if ULCFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULCObj.GetPeakFindKind: TPeakFindKind;
begin
  GetPeakFindKind := PULCRec(Rec)^.PeakFindKind;
end;

{/TULCObj}

end.
