unit ULLObju;
{ Generated by MakeComp 1.03 from ULLTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULNType,
  ULLType;

type
  TULLObj = class(TULObj)
  protected
    function GetChannelName: TChannelName;
    procedure SetChannelName(AChannelName: TChannelName);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property ChannelName: TChannelName
      read GetChannelName write SetChannelName;
  end;

const
  ULLChildRecIDs: array[0..0] of TULRecID = (
    ULNID
  );
  ULLFldDescs: array[0..0] of TULFldDesc = (
    (
     Caption: 'Default Channel';
     Hint: 'Name of the channel that will be used for new analysis';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4113;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: ULLID;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ChannelName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TChannelName';
    )
  );

  ULLRecDesc: TULRecDesc = (
    Caption: 'Channels';
    ChildRecIDsStr: 'ULNID';
    ChildRecIDs: @ULLChildRecIDs;
    ChildRecIDCount: 1;
    FldCount: 1;
    Flds: @ULLFldDescs;
    Flags: rfChildAllowed OR rfRootChild OR rfHasPointer OR rfEnabled OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TULLObj}
function TULLObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULLRec);
end;

constructor TULLObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULLID);
end;

function TULLObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULLRecDesc;
end;

procedure TULLObj.SetChannelName(AChannelName: TChannelName);
begin
  if PULLRec(Rec)^.ChannelName <> AChannelName then begin
    PULLRec(Rec)^.ChannelName := AChannelName;
    if ULLFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULLObj.GetChannelName: TChannelName;
begin
  GetChannelName := PULLRec(Rec)^.ChannelName;
end;

{/TULLObj}

end.
