unit ULMObju;
{ Generated by MakeComp 1.03 from ULMTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULBType,ULMFType,ULPType,
  ULMType;

type
  TULMObj = class(TULObj)
  protected
    function GetMethodTemplate: TULFileName;
    procedure SetMethodTemplate(AMethodTemplate: TULFileName);
    function GetCalibrationFileName: TULFileName;
    procedure SetCalibrationFileName(ACalibrationFileName: TULFileName);
    function GetMethodFileName: TULFileName;
    procedure SetMethodFileName(AMethodFileName: TULFileName);
    function GetDilution: TDilution;
    procedure SetDilution(ADilution: TDilution);
    function GetBaseMinInterval: single;
    procedure SetBaseMinInterval(ABaseMinInterval: single);
    function GetBaseMaxDiff: single;
    procedure SetBaseMaxDiff(ABaseMaxDiff: single);
    function GetMinPeakHeight: single;
    procedure SetMinPeakHeight(AMinPeakHeight: single);
    function GetMinPeakWidth: single;
    procedure SetMinPeakWidth(AMinPeakWidth: single);
    function GetUseNegativePeaks: boolean;
    procedure SetUseNegativePeaks(AUseNegativePeaks: boolean);
    function GetCalcAmounts: boolean;
    procedure SetCalcAmounts(ACalcAmounts: boolean);
    function GetUseCalibrationFile: boolean;
    procedure SetUseCalibrationFile(AUseCalibrationFile: boolean);
    function GetUseInternalStandard: boolean;
    procedure SetUseInternalStandard(AUseInternalStandard: boolean);
    function GetFactor: TFactor;
    procedure SetFactor(AFactor: TFactor);
    function GetCalibrationFileAge: integer;
    procedure SetCalibrationFileAge(ACalibrationFileAge: integer);
    function GetNoUnknownPeaks: boolean;
    procedure SetNoUnknownPeaks(ANoUnknownPeaks: boolean);
    function GetResultTableValue: TResultTableValue;
    procedure SetResultTableValue(AResultTableValue: TResultTableValue);
    function GetDefDataName: string;
    procedure SetDefDataName(ADefDataName: string);
    function GetUndilutedIS: boolean;
    procedure SetUndilutedIS(AUndilutedIS: boolean);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property MethodTemplate: TULFileName
      read GetMethodTemplate write SetMethodTemplate;
    property CalibrationFileName: TULFileName
      read GetCalibrationFileName write SetCalibrationFileName;
    property MethodFileName: TULFileName
      read GetMethodFileName write SetMethodFileName;
    property Dilution: TDilution
      read GetDilution write SetDilution;
    property BaseMinInterval: single
      read GetBaseMinInterval write SetBaseMinInterval;
    property BaseMaxDiff: single
      read GetBaseMaxDiff write SetBaseMaxDiff;
    property MinPeakHeight: single
      read GetMinPeakHeight write SetMinPeakHeight;
    property MinPeakWidth: single
      read GetMinPeakWidth write SetMinPeakWidth;
    property UseNegativePeaks: boolean
      read GetUseNegativePeaks write SetUseNegativePeaks;
    property CalcAmounts: boolean
      read GetCalcAmounts write SetCalcAmounts;
    property UseCalibrationFile: boolean
      read GetUseCalibrationFile write SetUseCalibrationFile;
    property UseInternalStandard: boolean
      read GetUseInternalStandard write SetUseInternalStandard;
    property Factor: TFactor
      read GetFactor write SetFactor;
    property CalibrationFileAge: integer
      read GetCalibrationFileAge write SetCalibrationFileAge;
    property NoUnknownPeaks: boolean
      read GetNoUnknownPeaks write SetNoUnknownPeaks;
    property ResultTableValue: TResultTableValue
      read GetResultTableValue write SetResultTableValue;
    property DefDataName: string
      read GetDefDataName write SetDefDataName;
    property UndilutedIS: boolean
      read GetUndilutedIS write SetUndilutedIS;
  end;

const
  ULMChildRecIDs: array[0..2] of TULRecID = (
    ULBID,ULMFID,ULPID
  );
  ULMFldDescs: array[0..17] of TULFldDesc = (
    (
     Caption: 'Method template';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4132;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'Method (*.ULM)|*.ULM';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MethodTemplate';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TULFileName';
    ),
    (
     Caption: 'Calibration file';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4133;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'CalibrationFileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TULFileName';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4132;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'Method (*.ULM)|*.ULM';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MethodFileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TULFileName';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4096;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Dilution';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TDilution';
    ),
    (
     Caption: 'Base.min.interval [min]';
     Hint: 'What is the minimal width of baseline section that should be autodetected';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 60.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'BaseMinInterval';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'single';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'BaseMaxDiff';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'single';
    ),
    (
     Caption: 'Min. peak height';
     Hint: 'What it the minimal height of the peak that should be autodetected';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MinPeakHeight';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'single';
    ),
    (
     Caption: 'Min. peak width [min]';
     Hint: 'What is the minimal width of peak that should be autodetected';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 60.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MinPeakWidth';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'single';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'UseNegativePeaks';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: '';
     Hint: 'Should peak amounts be calculated?';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'CalcAmounts';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: '';
     Hint: 'Should peak amounts be calculated using calibration file?';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'UseCalibrationFile';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: '';
     Hint: 'Should peak amounts be calculated using internal standard?';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'UseInternalStandard';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Factor';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFactor';
    ),
    (
     Caption: '';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4104;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'CalibrationFileAge';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'integer';
    ),
    (
     Caption: '';
     Hint: 'Check, if no other then peaks in method should be autodetected';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'NoUnknownPeaks';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'Results Value';
     Hint: 'Value of what peak property will be shown in results table';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: 'tv';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ResultTableValue';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TResultTableValue';
    ),
    (
     Caption: '';
     Hint: 'Default data line to process';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DefDataName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: '';
     Hint: 'Internal standard added after sample dilutions';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'UndilutedIS';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    )
  );

  ULMRecDesc: TULRecDesc = (
    Caption: 'Method';
    ChildRecIDsStr: 'ULBID,ULMFID,ULPID';
    ChildRecIDs: @ULMChildRecIDs;
    ChildRecIDCount: 3;
    FldCount: 18;
    Flds: @ULMFldDescs;
    Flags: rfChildAllowed OR rfRootChild OR rfEnabled OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TULMObj}
function TULMObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULMRec);
end;

constructor TULMObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULMID);
  BaseMinInterval := 20;
  BaseMaxDiff := 5e-3;
  MinPeakWidth := 1;
  MinPeakHeight := 0.05;
end;

function TULMObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULMRecDesc;
end;

procedure TULMObj.SetMethodTemplate(AMethodTemplate: TULFileName);
begin
  if PULMRec(Rec)^.MethodTemplate <> AMethodTemplate then begin
    PULMRec(Rec)^.MethodTemplate := AMethodTemplate;
    if ULMFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetMethodTemplate: TULFileName;
begin
  GetMethodTemplate := PULMRec(Rec)^.MethodTemplate;
end;

procedure TULMObj.SetCalibrationFileName(ACalibrationFileName: TULFileName);
begin
  if PULMRec(Rec)^.CalibrationFileName <> ACalibrationFileName then begin
    PULMRec(Rec)^.CalibrationFileName := ACalibrationFileName;
    if ULMFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetCalibrationFileName: TULFileName;
begin
  GetCalibrationFileName := PULMRec(Rec)^.CalibrationFileName;
end;

procedure TULMObj.SetMethodFileName(AMethodFileName: TULFileName);
begin
  if PULMRec(Rec)^.MethodFileName <> AMethodFileName then begin
    PULMRec(Rec)^.MethodFileName := AMethodFileName;
    if ULMFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetMethodFileName: TULFileName;
begin
  GetMethodFileName := PULMRec(Rec)^.MethodFileName;
end;

procedure TULMObj.SetDilution(ADilution: TDilution);
begin
  if PULMRec(Rec)^.Dilution <> ADilution then begin
    PULMRec(Rec)^.Dilution := ADilution;
    if ULMFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetDilution: TDilution;
begin
  GetDilution := PULMRec(Rec)^.Dilution;
end;

procedure TULMObj.SetBaseMinInterval(ABaseMinInterval: single);
begin
  if PULMRec(Rec)^.BaseMinInterval <> ABaseMinInterval then begin
    PULMRec(Rec)^.BaseMinInterval := ABaseMinInterval;
    if ULMFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetBaseMinInterval: single;
begin
  GetBaseMinInterval := PULMRec(Rec)^.BaseMinInterval;
end;

procedure TULMObj.SetBaseMaxDiff(ABaseMaxDiff: single);
begin
  if PULMRec(Rec)^.BaseMaxDiff <> ABaseMaxDiff then begin
    PULMRec(Rec)^.BaseMaxDiff := ABaseMaxDiff;
    if ULMFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetBaseMaxDiff: single;
begin
  GetBaseMaxDiff := PULMRec(Rec)^.BaseMaxDiff;
end;

procedure TULMObj.SetMinPeakHeight(AMinPeakHeight: single);
begin
  if PULMRec(Rec)^.MinPeakHeight <> AMinPeakHeight then begin
    PULMRec(Rec)^.MinPeakHeight := AMinPeakHeight;
    if ULMFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetMinPeakHeight: single;
begin
  GetMinPeakHeight := PULMRec(Rec)^.MinPeakHeight;
end;

procedure TULMObj.SetMinPeakWidth(AMinPeakWidth: single);
begin
  if PULMRec(Rec)^.MinPeakWidth <> AMinPeakWidth then begin
    PULMRec(Rec)^.MinPeakWidth := AMinPeakWidth;
    if ULMFldDescs[7].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetMinPeakWidth: single;
begin
  GetMinPeakWidth := PULMRec(Rec)^.MinPeakWidth;
end;

procedure TULMObj.SetUseNegativePeaks(AUseNegativePeaks: boolean);
begin
  if PULMRec(Rec)^.UseNegativePeaks <> AUseNegativePeaks then begin
    PULMRec(Rec)^.UseNegativePeaks := AUseNegativePeaks;
    if ULMFldDescs[8].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetUseNegativePeaks: boolean;
begin
  GetUseNegativePeaks := PULMRec(Rec)^.UseNegativePeaks;
end;

procedure TULMObj.SetCalcAmounts(ACalcAmounts: boolean);
begin
  if PULMRec(Rec)^.CalcAmounts <> ACalcAmounts then begin
    PULMRec(Rec)^.CalcAmounts := ACalcAmounts;
    if ULMFldDescs[9].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetCalcAmounts: boolean;
begin
  GetCalcAmounts := PULMRec(Rec)^.CalcAmounts;
end;

procedure TULMObj.SetUseCalibrationFile(AUseCalibrationFile: boolean);
begin
  if PULMRec(Rec)^.UseCalibrationFile <> AUseCalibrationFile then begin
    PULMRec(Rec)^.UseCalibrationFile := AUseCalibrationFile;
    if ULMFldDescs[10].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetUseCalibrationFile: boolean;
begin
  GetUseCalibrationFile := PULMRec(Rec)^.UseCalibrationFile;
end;

procedure TULMObj.SetUseInternalStandard(AUseInternalStandard: boolean);
begin
  if PULMRec(Rec)^.UseInternalStandard <> AUseInternalStandard then begin
    PULMRec(Rec)^.UseInternalStandard := AUseInternalStandard;
    if ULMFldDescs[11].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetUseInternalStandard: boolean;
begin
  GetUseInternalStandard := PULMRec(Rec)^.UseInternalStandard;
end;

procedure TULMObj.SetFactor(AFactor: TFactor);
begin
  if PULMRec(Rec)^.Factor <> AFactor then begin
    PULMRec(Rec)^.Factor := AFactor;
    if ULMFldDescs[12].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetFactor: TFactor;
begin
  GetFactor := PULMRec(Rec)^.Factor;
end;

procedure TULMObj.SetCalibrationFileAge(ACalibrationFileAge: integer);
begin
  if PULMRec(Rec)^.CalibrationFileAge <> ACalibrationFileAge then begin
    PULMRec(Rec)^.CalibrationFileAge := ACalibrationFileAge;
    if ULMFldDescs[13].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetCalibrationFileAge: integer;
begin
  GetCalibrationFileAge := PULMRec(Rec)^.CalibrationFileAge;
end;

procedure TULMObj.SetNoUnknownPeaks(ANoUnknownPeaks: boolean);
begin
  if PULMRec(Rec)^.NoUnknownPeaks <> ANoUnknownPeaks then begin
    PULMRec(Rec)^.NoUnknownPeaks := ANoUnknownPeaks;
    if ULMFldDescs[14].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetNoUnknownPeaks: boolean;
begin
  GetNoUnknownPeaks := PULMRec(Rec)^.NoUnknownPeaks;
end;

procedure TULMObj.SetResultTableValue(AResultTableValue: TResultTableValue);
begin
  if PULMRec(Rec)^.ResultTableValue <> AResultTableValue then begin
    PULMRec(Rec)^.ResultTableValue := AResultTableValue;
    if ULMFldDescs[15].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetResultTableValue: TResultTableValue;
begin
  GetResultTableValue := PULMRec(Rec)^.ResultTableValue;
end;

procedure TULMObj.SetDefDataName(ADefDataName: string);
begin
  if PULMRec(Rec)^.DefDataName <> ADefDataName then begin
    PULMRec(Rec)^.DefDataName := ADefDataName;
    if ULMFldDescs[16].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetDefDataName: string;
begin
  GetDefDataName := PULMRec(Rec)^.DefDataName;
end;

procedure TULMObj.SetUndilutedIS(AUndilutedIS: boolean);
begin
  if PULMRec(Rec)^.UndilutedIS <> AUndilutedIS then begin
    PULMRec(Rec)^.UndilutedIS := AUndilutedIS;
    if ULMFldDescs[17].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULMObj.GetUndilutedIS: boolean;
begin
  GetUndilutedIS := PULMRec(Rec)^.UndilutedIS;
end;

{/TULMObj}

end.
