unit ULNObju;
{ Generated by MakeComp 1.03 from ULNTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULNDType,
  ULNType;

type
  TULNObj = class(TULObj)
  protected
    function GetChannelName: TChannelName;
    procedure SetChannelName(AChannelName: TChannelName);
    function GetColor: integer;
    procedure SetColor(AColor: integer);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property ChannelName: TChannelName
      read GetChannelName write SetChannelName;
    property Color: integer
      read GetColor write SetColor;
  end;

const
  ULNChildRecIDs: array[0..0] of TULRecID = (
    ULNDID
  );
  ULNFldDescs: array[0..1] of TULFldDesc = (
    (
     Caption: 'Channel name';
     Hint: 'User defined unique name of the channel (=set of devices)';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ChannelName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TChannelName';
    ),
    (
     Caption: 'Channel Color';
     Hint: 'Used during acquisition in windows to write channel name';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 266273;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Color';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'integer';
    )
  );

  ULNRecDesc: TULRecDesc = (
    Caption: 'Channel';
    ChildRecIDsStr: 'ULNDID';
    ChildRecIDs: @ULNChildRecIDs;
    ChildRecIDCount: 1;
    FldCount: 2;
    Flds: @ULNFldDescs;
    Flags: rfChildAllowed OR rfRootChild OR rfHasRecName OR rfUsingColors OR rfEnabled OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TULNObj}
function TULNObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULNRec);
end;

constructor TULNObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULNID);
  SetFlag(rfUsingColors, true);
  Color := clBlue;
end;

function TULNObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULNRecDesc;
end;

procedure TULNObj.SetChannelName(AChannelName: TChannelName);
begin
  if PULNRec(Rec)^.ChannelName <> AChannelName then begin
    PULNRec(Rec)^.ChannelName := AChannelName;
    if ULNFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULNObj.GetChannelName: TChannelName;
begin
  GetChannelName := PULNRec(Rec)^.ChannelName;
end;

procedure TULNObj.SetColor(AColor: integer);
begin
  if PULNRec(Rec)^.Color <> AColor then begin
    PULNRec(Rec)^.Color := AColor;
    if ULNFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULNObj.GetColor: integer;
begin
  GetColor := PULNRec(Rec)^.Color;
end;

{/TULNObj}

end.
