unit ULSRObju;
{ Generated by MakeComp 1.03 from ULSRTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULMType,ULIType,AAPGType,USPType,
  ULSRType;

type
  TULSRObj = class(TULObj)
  protected
    function GetSampleName: TSampleName;
    procedure SetSampleName(ASampleName: TSampleName);
    function GetSampleNr: integer;
    procedure SetSampleNr(ASampleNr: integer);
    function GetVialNr: integer;
    procedure SetVialNr(AVialNr: integer);
    function GetSampleDesc: TSampleDesc;
    procedure SetSampleDesc(ASampleDesc: TSampleDesc);
    function GetDateTime: longint;
    procedure SetDateTime(ADateTime: longint);
    function GetUserName: TUserName;
    procedure SetUserName(AUserName: TUserName);
    function GetFileName: TFileName;
    procedure SetFileName(AFileName: TFileName);
    function GetPrgFileName: TFileName;
    procedure SetPrgFileName(APrgFileName: TFileName);
    function GetSampleState: TSampleState;
    procedure SetSampleState(ASampleState: TSampleState);
    function GetMethodFileName: TFileName;
    procedure SetMethodFileName(AMethodFileName: TFileName);
    function GetProgramLoad: TNotifyEvent;
    procedure SetProgramLoad(AProgramLoad: TNotifyEvent);
    function GetProgramEdit: TNotifyEvent;
    procedure SetProgramEdit(AProgramEdit: TNotifyEvent);
    function GetProgramSave: TNotifyEvent;
    procedure SetProgramSave(AProgramSave: TNotifyEvent);
    function GetMethodLoad: TNotifyEvent;
    procedure SetMethodLoad(AMethodLoad: TNotifyEvent);
    function GetMethodEdit: TNotifyEvent;
    procedure SetMethodEdit(AMethodEdit: TNotifyEvent);
    function GetMethodSave: TNotifyEvent;
    procedure SetMethodSave(AMethodSave: TNotifyEvent);
    function GetMultiplyFactor: TFactor;
    procedure SetMultiplyFactor(AMultiplyFactor: TFactor);
    function GetDivideFactor: TFactor;
    procedure SetDivideFactor(ADivideFactor: TFactor);
    function GetCalibrationStandard: boolean;
    procedure SetCalibrationStandard(ACalibrationStandard: boolean);
    function GetProtocol: string;
    procedure SetProtocol(AProtocol: string);
    function GetDataTemplateFileName: string;
    procedure SetDataTemplateFileName(ADataTemplateFileName: string);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property SampleName: TSampleName
      read GetSampleName write SetSampleName;
    property SampleNr: integer
      read GetSampleNr write SetSampleNr;
    property VialNr: integer
      read GetVialNr write SetVialNr;
    property SampleDesc: TSampleDesc
      read GetSampleDesc write SetSampleDesc;
    property DateTime: longint
      read GetDateTime write SetDateTime;
    property UserName: TUserName
      read GetUserName write SetUserName;
    property FileName: TFileName
      read GetFileName write SetFileName;
    property PrgFileName: TFileName
      read GetPrgFileName write SetPrgFileName;
    property SampleState: TSampleState
      read GetSampleState write SetSampleState;
    property MethodFileName: TFileName
      read GetMethodFileName write SetMethodFileName;
    property ProgramLoad: TNotifyEvent
      read GetProgramLoad write SetProgramLoad;
    property ProgramEdit: TNotifyEvent
      read GetProgramEdit write SetProgramEdit;
    property ProgramSave: TNotifyEvent
      read GetProgramSave write SetProgramSave;
    property MethodLoad: TNotifyEvent
      read GetMethodLoad write SetMethodLoad;
    property MethodEdit: TNotifyEvent
      read GetMethodEdit write SetMethodEdit;
    property MethodSave: TNotifyEvent
      read GetMethodSave write SetMethodSave;
    property MultiplyFactor: TFactor
      read GetMultiplyFactor write SetMultiplyFactor;
    property DivideFactor: TFactor
      read GetDivideFactor write SetDivideFactor;
    property CalibrationStandard: boolean
      read GetCalibrationStandard write SetCalibrationStandard;
    property Protocol: string
      read GetProtocol write SetProtocol;
    property DataTemplateFileName: string
      read GetDataTemplateFileName write SetDataTemplateFileName;
  end;

const
  ULSRChildRecIDs: array[0..3] of TULRecID = (
    ULIID,ULMID,AAPGID,USPID
  );
     FieldColors8 : array[0..5] of TULFieldColor = (
      (clWhite,clGreen),
      (clBlack,clYellow),
      (clBlack,clWhite),
      (clBlack,clGray),
      (clBlack,clGray),
      (clWhite,clRed)
     );

  ULSRFldDescs: array[0..20] of TULFldDesc = (
    (
     Caption: '';
     Hint: 'Sample name (usually unique in the sequence)';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SampleName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSampleName';
    ),
    (
     Caption: 'Sample Nr.';
     Hint: 'Automatically assigned sample order number';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4096;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SampleNr';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'integer';
    ),
    (
     Caption: 'Vial Nr.';
     Hint: 'Number of the sample position in the autosampler';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'VialNr';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'integer';
    ),
    (
     Caption: 'Sample Desc.';
     Hint: 'Longer description of the sample';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SampleDesc';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSampleDesc';
    ),
    (
     Caption: 'Date';
     Hint: 'Date/Time when the sample was added to sequence';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4105;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DateTime';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'longint';
    ),
    (
     Caption: '';
     Hint: 'Name of the person who made the analysis';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'UserName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TUserName';
    ),
    (
     Caption: 'File name';
     Hint: 'Name for the file with acquired data';
     EditWidth: 0;
     BrowseWidth: 60;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'FileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFileName';
    ),
    (
     Caption: 'Program name';
     Hint: 'Name of the file with sequence program';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4133;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'AA Analyser Program (*.AAP)|*.AAP';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PrgFileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFileName';
    ),
    (
     Caption: 'State';
     Hint: 'Current state of the sample';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4096;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 6;
     FieldColors : @FieldColors8;
     Filter: '';
     DefDir: '';
     StripPrefix: 'sas';
     EditMask: '';
     MaxID: 0;
     FieldName: 'SampleState';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TSampleState';
    ),
    (
     Caption: 'Method name';
     Hint: 'Name of method file (used for acquired data evaluation)';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4133;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'Method (*.ULM)|*.ULM';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MethodFileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFileName';
    ),
    (
     Caption: 'Load Program';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 130;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ProgramLoad';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TNotifyEvent';
    ),
    (
     Caption: 'Modify Program';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 130;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ProgramEdit';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TNotifyEvent';
    ),
    (
     Caption: 'Save Program';
     Hint: 'Save Program info to file';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 130;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ProgramSave';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TNotifyEvent';
    ),
    (
     Caption: 'Load Method';
     Hint: 'Load method info from file';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 130;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MethodLoad';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TNotifyEvent';
    ),
    (
     Caption: 'Modify Method';
     Hint: 'Modify Method information';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 130;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MethodEdit';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TNotifyEvent';
    ),
    (
     Caption: 'Save Method';
     Hint: 'Save method info to file';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 130;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MethodSave';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TNotifyEvent';
    ),
    (
     Caption: 'Mult.factor';
     Hint: 'Used to multiply results with';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MultiplyFactor';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFactor';
    ),
    (
     Caption: 'Dif.factor';
     Hint: 'Used to divide results with';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DivideFactor';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TFactor';
    ),
    (
     Caption: 'Cal.std.';
     Hint: 'Will be this sample used as calibration standard?';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'CalibrationStandard';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: '';
     Hint: 'Eventual unusual events during acquisition logged here';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4161;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Protocol';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Template name';
     Hint: 'Template used for acquiring the sample';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4133;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'Template (*.ULT)|*.ULT';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DataTemplateFileName';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    )
  );

  ULSRRecDesc: TULRecDesc = (
    Caption: 'Sample';
    ChildRecIDsStr: 'ULIID,ULMID,AAPGID,USPID';
    ChildRecIDs: @ULSRChildRecIDs;
    ChildRecIDCount: 4;
    FldCount: 21;
    Flds: @ULSRFldDescs;
    Flags: rfChildAllowed OR rfHasRecName OR rfUsingColors OR rfEnabled OR rfEditModal OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: 'SampleNr,VialNr,FileName,SampleState,DataTemplateFileName,PrgFileName,MethodFileName,MultiplyFactor,DivideFactor,CalibrationStandard,SampleName,SampleDesc,Date,UserName';
    MenuFieldList: '';
    BrowseChildRecIDs: '0';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TULSRObj}
function TULSRObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULSRRec);
end;

constructor TULSRObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULSRID);
  DateTime := DateTimeToFileDate(Now);
  MultiplyFactor := 1;
  DivideFactor := 1;
end;

function TULSRObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULSRRecDesc;
end;

procedure TULSRObj.SetSampleName(ASampleName: TSampleName);
begin
  if PULSRRec(Rec)^.SampleName <> ASampleName then begin
    PULSRRec(Rec)^.SampleName := ASampleName;
    if ULSRFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetSampleName: TSampleName;
begin
  GetSampleName := PULSRRec(Rec)^.SampleName;
end;

procedure TULSRObj.SetSampleNr(ASampleNr: integer);
begin
  if PULSRRec(Rec)^.SampleNr <> ASampleNr then begin
    PULSRRec(Rec)^.SampleNr := ASampleNr;
    if ULSRFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetSampleNr: integer;
begin
  GetSampleNr := PULSRRec(Rec)^.SampleNr;
end;

procedure TULSRObj.SetVialNr(AVialNr: integer);
begin
  if PULSRRec(Rec)^.VialNr <> AVialNr then begin
    PULSRRec(Rec)^.VialNr := AVialNr;
    if ULSRFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetVialNr: integer;
begin
  GetVialNr := PULSRRec(Rec)^.VialNr;
end;

procedure TULSRObj.SetSampleDesc(ASampleDesc: TSampleDesc);
begin
  if PULSRRec(Rec)^.SampleDesc <> ASampleDesc then begin
    PULSRRec(Rec)^.SampleDesc := ASampleDesc;
    if ULSRFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetSampleDesc: TSampleDesc;
begin
  GetSampleDesc := PULSRRec(Rec)^.SampleDesc;
end;

procedure TULSRObj.SetDateTime(ADateTime: longint);
begin
  if PULSRRec(Rec)^.DateTime <> ADateTime then begin
    PULSRRec(Rec)^.DateTime := ADateTime;
    if ULSRFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetDateTime: longint;
begin
  GetDateTime := PULSRRec(Rec)^.DateTime;
end;

procedure TULSRObj.SetUserName(AUserName: TUserName);
begin
  if PULSRRec(Rec)^.UserName <> AUserName then begin
    PULSRRec(Rec)^.UserName := AUserName;
    if ULSRFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetUserName: TUserName;
begin
  GetUserName := PULSRRec(Rec)^.UserName;
end;

procedure TULSRObj.SetFileName(AFileName: TFileName);
begin
  if PULSRRec(Rec)^.FileName <> AFileName then begin
    PULSRRec(Rec)^.FileName := AFileName;
    if ULSRFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetFileName: TFileName;
begin
  GetFileName := PULSRRec(Rec)^.FileName;
end;

procedure TULSRObj.SetPrgFileName(APrgFileName: TFileName);
begin
  if PULSRRec(Rec)^.PrgFileName <> APrgFileName then begin
    PULSRRec(Rec)^.PrgFileName := APrgFileName;
    if ULSRFldDescs[7].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetPrgFileName: TFileName;
begin
  GetPrgFileName := PULSRRec(Rec)^.PrgFileName;
end;

procedure TULSRObj.SetSampleState(ASampleState: TSampleState);
begin
  if PULSRRec(Rec)^.SampleState <> ASampleState then begin
    PULSRRec(Rec)^.SampleState := ASampleState;
    if ULSRFldDescs[8].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetSampleState: TSampleState;
begin
  GetSampleState := PULSRRec(Rec)^.SampleState;
end;

procedure TULSRObj.SetMethodFileName(AMethodFileName: TFileName);
begin
  if PULSRRec(Rec)^.MethodFileName <> AMethodFileName then begin
    PULSRRec(Rec)^.MethodFileName := AMethodFileName;
    if ULSRFldDescs[9].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetMethodFileName: TFileName;
begin
  GetMethodFileName := PULSRRec(Rec)^.MethodFileName;
end;

procedure TULSRObj.SetProgramLoad(AProgramLoad: TNotifyEvent);
begin
    PULSRRec(Rec)^.ProgramLoad := AProgramLoad;
    if ULSRFldDescs[10].VarSize then 
      ClearFieldsLen;
    DoChange;
    {$IFNDEF CONSOLE}
    Fields[10].Method := TMethod(AProgramLoad);
    {$ENDIF}
end;

function TULSRObj.GetProgramLoad: TNotifyEvent;
begin
  GetProgramLoad := PULSRRec(Rec)^.ProgramLoad;
end;

procedure TULSRObj.SetProgramEdit(AProgramEdit: TNotifyEvent);
begin
    PULSRRec(Rec)^.ProgramEdit := AProgramEdit;
    if ULSRFldDescs[11].VarSize then 
      ClearFieldsLen;
    DoChange;
    {$IFNDEF CONSOLE}
    Fields[11].Method := TMethod(AProgramEdit);
    {$ENDIF}
end;

function TULSRObj.GetProgramEdit: TNotifyEvent;
begin
  GetProgramEdit := PULSRRec(Rec)^.ProgramEdit;
end;

procedure TULSRObj.SetProgramSave(AProgramSave: TNotifyEvent);
begin
    PULSRRec(Rec)^.ProgramSave := AProgramSave;
    if ULSRFldDescs[12].VarSize then 
      ClearFieldsLen;
    DoChange;
    {$IFNDEF CONSOLE}
    Fields[12].Method := TMethod(AProgramSave);
    {$ENDIF}
end;

function TULSRObj.GetProgramSave: TNotifyEvent;
begin
  GetProgramSave := PULSRRec(Rec)^.ProgramSave;
end;

procedure TULSRObj.SetMethodLoad(AMethodLoad: TNotifyEvent);
begin
    PULSRRec(Rec)^.MethodLoad := AMethodLoad;
    if ULSRFldDescs[13].VarSize then 
      ClearFieldsLen;
    DoChange;
    {$IFNDEF CONSOLE}
    Fields[13].Method := TMethod(AMethodLoad);
    {$ENDIF}
end;

function TULSRObj.GetMethodLoad: TNotifyEvent;
begin
  GetMethodLoad := PULSRRec(Rec)^.MethodLoad;
end;

procedure TULSRObj.SetMethodEdit(AMethodEdit: TNotifyEvent);
begin
    PULSRRec(Rec)^.MethodEdit := AMethodEdit;
    if ULSRFldDescs[14].VarSize then 
      ClearFieldsLen;
    DoChange;
    {$IFNDEF CONSOLE}
    Fields[14].Method := TMethod(AMethodEdit);
    {$ENDIF}
end;

function TULSRObj.GetMethodEdit: TNotifyEvent;
begin
  GetMethodEdit := PULSRRec(Rec)^.MethodEdit;
end;

procedure TULSRObj.SetMethodSave(AMethodSave: TNotifyEvent);
begin
    PULSRRec(Rec)^.MethodSave := AMethodSave;
    if ULSRFldDescs[15].VarSize then 
      ClearFieldsLen;
    DoChange;
    {$IFNDEF CONSOLE}
    Fields[15].Method := TMethod(AMethodSave);
    {$ENDIF}
end;

function TULSRObj.GetMethodSave: TNotifyEvent;
begin
  GetMethodSave := PULSRRec(Rec)^.MethodSave;
end;

procedure TULSRObj.SetMultiplyFactor(AMultiplyFactor: TFactor);
begin
  if PULSRRec(Rec)^.MultiplyFactor <> AMultiplyFactor then begin
    PULSRRec(Rec)^.MultiplyFactor := AMultiplyFactor;
    if ULSRFldDescs[16].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetMultiplyFactor: TFactor;
begin
  GetMultiplyFactor := PULSRRec(Rec)^.MultiplyFactor;
end;

procedure TULSRObj.SetDivideFactor(ADivideFactor: TFactor);
begin
  if PULSRRec(Rec)^.DivideFactor <> ADivideFactor then begin
    PULSRRec(Rec)^.DivideFactor := ADivideFactor;
    if ULSRFldDescs[17].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetDivideFactor: TFactor;
begin
  GetDivideFactor := PULSRRec(Rec)^.DivideFactor;
end;

procedure TULSRObj.SetCalibrationStandard(ACalibrationStandard: boolean);
begin
  if PULSRRec(Rec)^.CalibrationStandard <> ACalibrationStandard then begin
    PULSRRec(Rec)^.CalibrationStandard := ACalibrationStandard;
    if ULSRFldDescs[18].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetCalibrationStandard: boolean;
begin
  GetCalibrationStandard := PULSRRec(Rec)^.CalibrationStandard;
end;

procedure TULSRObj.SetProtocol(AProtocol: string);
begin
  if PULSRRec(Rec)^.Protocol <> AProtocol then begin
    PULSRRec(Rec)^.Protocol := AProtocol;
    if ULSRFldDescs[19].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetProtocol: string;
begin
  GetProtocol := PULSRRec(Rec)^.Protocol;
end;

procedure TULSRObj.SetDataTemplateFileName(ADataTemplateFileName: string);
begin
  if PULSRRec(Rec)^.DataTemplateFileName <> ADataTemplateFileName then begin
    PULSRRec(Rec)^.DataTemplateFileName := ADataTemplateFileName;
    if ULSRFldDescs[20].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULSRObj.GetDataTemplateFileName: string;
begin
  GetDataTemplateFileName := PULSRRec(Rec)^.DataTemplateFileName;
end;

{/TULSRObj}

end.
