unit ULVLObju;
{ Generated by MakeComp 1.03 from ULVLTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULVLType;

type
  TULVLObj = class(TULObj)
  protected
    function GetFixedView: boolean;
    procedure SetFixedView(AFixedView: boolean);
    function GetMinX: TUserX;
    procedure SetMinX(AMinX: TUserX);
    function GetMinY: TUserY;
    procedure SetMinY(AMinY: TUserY);
    function GetMaxX: TUserX;
    procedure SetMaxX(AMaxX: TUserX);
    function GetMaxY: TUserY;
    procedure SetMaxY(AMaxY: TUserY);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property FixedView: boolean
      read GetFixedView write SetFixedView;
    property MinX: TUserX
      read GetMinX write SetMinX;
    property MinY: TUserY
      read GetMinY write SetMinY;
    property MaxX: TUserX
      read GetMaxX write SetMaxX;
    property MaxY: TUserY
      read GetMaxY write SetMaxY;
  end;

const
  ULVLFldDescs: array[0..4] of TULFldDesc = (
    (
     Caption: 'Use fixed view';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'FixedView';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'X1 (min)';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MinX';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TUserX';
    ),
    (
     Caption: 'Y1 (AU)';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MinY';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TUserY';
    ),
    (
     Caption: 'X2 (min)';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MaxX';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TUserX';
    ),
    (
     Caption: 'Y2 (AU)';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'MaxY';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TUserY';
    )
  );

  ULVLRecDesc: TULRecDesc = (
    Caption: 'View Limits';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 5;
    Flds: @ULVLFldDescs;
    Flags: rfEnabled OR rfEditModal OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TULVLObj}
function TULVLObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULVLRec);
end;

constructor TULVLObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULVLID);
end;

function TULVLObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULVLRecDesc;
end;

procedure TULVLObj.SetFixedView(AFixedView: boolean);
begin
  if PULVLRec(Rec)^.FixedView <> AFixedView then begin
    PULVLRec(Rec)^.FixedView := AFixedView;
    if ULVLFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVLObj.GetFixedView: boolean;
begin
  GetFixedView := PULVLRec(Rec)^.FixedView;
end;

procedure TULVLObj.SetMinX(AMinX: TUserX);
begin
  if PULVLRec(Rec)^.MinX <> AMinX then begin
    PULVLRec(Rec)^.MinX := AMinX;
    if ULVLFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVLObj.GetMinX: TUserX;
begin
  GetMinX := PULVLRec(Rec)^.MinX;
end;

procedure TULVLObj.SetMinY(AMinY: TUserY);
begin
  if PULVLRec(Rec)^.MinY <> AMinY then begin
    PULVLRec(Rec)^.MinY := AMinY;
    if ULVLFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVLObj.GetMinY: TUserY;
begin
  GetMinY := PULVLRec(Rec)^.MinY;
end;

procedure TULVLObj.SetMaxX(AMaxX: TUserX);
begin
  if PULVLRec(Rec)^.MaxX <> AMaxX then begin
    PULVLRec(Rec)^.MaxX := AMaxX;
    if ULVLFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVLObj.GetMaxX: TUserX;
begin
  GetMaxX := PULVLRec(Rec)^.MaxX;
end;

procedure TULVLObj.SetMaxY(AMaxY: TUserY);
begin
  if PULVLRec(Rec)^.MaxY <> AMaxY then begin
    PULVLRec(Rec)^.MaxY := AMaxY;
    if ULVLFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVLObj.GetMaxY: TUserY;
begin
  GetMaxY := PULVLRec(Rec)^.MaxY;
end;

{/TULVLObj}

end.
