unit ULVOObju;
{ Generated by MakeComp 1.03 from ULVOTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  ULVOType;

type
  TULVOObj = class(TULObj)
  protected
    function GetShowData: boolean;
    procedure SetShowData(AShowData: boolean);
    function GetShowPeaks: boolean;
    procedure SetShowPeaks(AShowPeaks: boolean);
    function GetShowAxis: boolean;
    procedure SetShowAxis(AShowAxis: boolean);
    function GetShowBaseline: boolean;
    procedure SetShowBaseline(AShowBaseline: boolean);
    function GetShowHeader: boolean;
    procedure SetShowHeader(AShowHeader: boolean);
    function GetShowReport: boolean;
    procedure SetShowReport(AShowReport: boolean);
    function GetShowXY: boolean;
    procedure SetShowXY(AShowXY: boolean);
    function GetPointCircleRadius: integer;
    procedure SetPointCircleRadius(APointCircleRadius: integer);
    function GetAutoShowReport: boolean;
    procedure SetAutoShowReport(AAutoShowReport: boolean);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
  published
    property ShowData: boolean
      read GetShowData write SetShowData;
    property ShowPeaks: boolean
      read GetShowPeaks write SetShowPeaks;
    property ShowAxis: boolean
      read GetShowAxis write SetShowAxis;
    property ShowBaseline: boolean
      read GetShowBaseline write SetShowBaseline;
    property ShowHeader: boolean
      read GetShowHeader write SetShowHeader;
    property ShowReport: boolean
      read GetShowReport write SetShowReport;
    property ShowXY: boolean
      read GetShowXY write SetShowXY;
    property PointCircleRadius: integer
      read GetPointCircleRadius write SetPointCircleRadius;
    property AutoShowReport: boolean
      read GetAutoShowReport write SetAutoShowReport;
  end;

const
  ULVOFldDescs: array[0..8] of TULFldDesc = (
    (
     Caption: 'Show data';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ShowData';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'Show peaks';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ShowPeaks';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'Show axis';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ShowAxis';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'Show baseline';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ShowBaseline';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'Show header';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ShowHeader';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'Show report';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ShowReport';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: 'Show mouse coordinates';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'ShowXY';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    ),
    (
     Caption: '';
     Hint: 'Radius of circle draw around experimental point (0 = none)';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PointCircleRadius';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'integer';
    ),
    (
     Caption: '';
     Hint: 'Show report panel upon every recalculation?';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'AutoShowReport';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'boolean';
    )
  );

  ULVORecDesc: TULRecDesc = (
    Caption: 'View options';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 9;
    Flds: @ULVOFldDescs;
    Flags: rfEnabled OR rfVisible;
    SortExp: '';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TULVOObj}
function TULVOObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TULVORec);
end;

constructor TULVOObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), ULVOID);
  ShowData := true; ShowAxis := true;
end;

function TULVOObj.GetULRecDesc: PULRecDesc;
begin
  Result := @ULVORecDesc;
end;

procedure TULVOObj.SetShowData(AShowData: boolean);
begin
  if PULVORec(Rec)^.ShowData <> AShowData then begin
    PULVORec(Rec)^.ShowData := AShowData;
    if ULVOFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVOObj.GetShowData: boolean;
begin
  GetShowData := PULVORec(Rec)^.ShowData;
end;

procedure TULVOObj.SetShowPeaks(AShowPeaks: boolean);
begin
  if PULVORec(Rec)^.ShowPeaks <> AShowPeaks then begin
    PULVORec(Rec)^.ShowPeaks := AShowPeaks;
    if ULVOFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVOObj.GetShowPeaks: boolean;
begin
  GetShowPeaks := PULVORec(Rec)^.ShowPeaks;
end;

procedure TULVOObj.SetShowAxis(AShowAxis: boolean);
begin
  if PULVORec(Rec)^.ShowAxis <> AShowAxis then begin
    PULVORec(Rec)^.ShowAxis := AShowAxis;
    if ULVOFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVOObj.GetShowAxis: boolean;
begin
  GetShowAxis := PULVORec(Rec)^.ShowAxis;
end;

procedure TULVOObj.SetShowBaseline(AShowBaseline: boolean);
begin
  if PULVORec(Rec)^.ShowBaseline <> AShowBaseline then begin
    PULVORec(Rec)^.ShowBaseline := AShowBaseline;
    if ULVOFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVOObj.GetShowBaseline: boolean;
begin
  GetShowBaseline := PULVORec(Rec)^.ShowBaseline;
end;

procedure TULVOObj.SetShowHeader(AShowHeader: boolean);
begin
  if PULVORec(Rec)^.ShowHeader <> AShowHeader then begin
    PULVORec(Rec)^.ShowHeader := AShowHeader;
    if ULVOFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVOObj.GetShowHeader: boolean;
begin
  GetShowHeader := PULVORec(Rec)^.ShowHeader;
end;

procedure TULVOObj.SetShowReport(AShowReport: boolean);
begin
  if PULVORec(Rec)^.ShowReport <> AShowReport then begin
    PULVORec(Rec)^.ShowReport := AShowReport;
    if ULVOFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVOObj.GetShowReport: boolean;
begin
  GetShowReport := PULVORec(Rec)^.ShowReport;
end;

procedure TULVOObj.SetShowXY(AShowXY: boolean);
begin
  if PULVORec(Rec)^.ShowXY <> AShowXY then begin
    PULVORec(Rec)^.ShowXY := AShowXY;
    if ULVOFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVOObj.GetShowXY: boolean;
begin
  GetShowXY := PULVORec(Rec)^.ShowXY;
end;

procedure TULVOObj.SetPointCircleRadius(APointCircleRadius: integer);
begin
  if PULVORec(Rec)^.PointCircleRadius <> APointCircleRadius then begin
    PULVORec(Rec)^.PointCircleRadius := APointCircleRadius;
    if ULVOFldDescs[7].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVOObj.GetPointCircleRadius: integer;
begin
  GetPointCircleRadius := PULVORec(Rec)^.PointCircleRadius;
end;

procedure TULVOObj.SetAutoShowReport(AAutoShowReport: boolean);
begin
  if PULVORec(Rec)^.AutoShowReport <> AAutoShowReport then begin
    PULVORec(Rec)^.AutoShowReport := AAutoShowReport;
    if ULVOFldDescs[8].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TULVOObj.GetAutoShowReport: boolean;
begin
  GetAutoShowReport := PULVORec(Rec)^.AutoShowReport;
end;

{/TULVOObj}

end.
