unit USPDObju;
{ Generated by MakeComp 1.03 from USPDTYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  USPDType;

type
  TUSPDObj = class(TULObj)
  protected
    function GetPrgTime: TAcqTime;
    procedure SetPrgTime(APrgTime: TAcqTime);
    function GetDeviceAlias: string;
    procedure SetDeviceAlias(ADeviceAlias: string);
    function GetLineType: TInDeviceLineType;
    procedure SetLineType(ALineType: TInDeviceLineType);
    function GetParam1: TScriptParam;
    procedure SetParam1(AParam1: TScriptParam);
    function GetParam2: TScriptParam;
    procedure SetParam2(AParam2: TScriptParam);
    function GetParam3: TScriptParam;
    procedure SetParam3(AParam3: TScriptParam);
    function GetNote: TPrgLineNote;
    procedure SetNote(ANote: TPrgLineNote);
    function GetState: TPrgLineState;
    procedure SetState(AState: TPrgLineState);
    function GetDuration: TAcqTime;
    procedure SetDuration(ADuration: TAcqTime);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
    function GetSortNum: extended; override;
  published
    property PrgTime: TAcqTime
      read GetPrgTime write SetPrgTime;
    property DeviceAlias: string
      read GetDeviceAlias write SetDeviceAlias;
    property LineType: TInDeviceLineType
      read GetLineType write SetLineType;
    property Param1: TScriptParam
      read GetParam1 write SetParam1;
    property Param2: TScriptParam
      read GetParam2 write SetParam2;
    property Param3: TScriptParam
      read GetParam3 write SetParam3;
    property Note: TPrgLineNote
      read GetNote write SetNote;
    property State: TPrgLineState
      read GetState write SetState;
    property Duration: TAcqTime
      read GetDuration write SetDuration;
  end;

const
     FieldColors7 : array[0..5] of TULFieldColor = (
      (clBlack,clWhite),
      (clWhite,clGreen),
      (clBlack,clYellow),
      (clBlack,clGray),
      (clWhite,clRed),
      (clBlack,clWhite)
     );

  USPDFldDescs: array[0..8] of TULFldDesc = (
    (
     Caption: 'Time [min]';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 6145;
     UserCoef: 60.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PrgTime';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TAcqTime';
    ),
    (
     Caption: 'Device alias';
     Hint: 'In what current channel device should be the command executed';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'DeviceAlias';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'string';
    ),
    (
     Caption: 'Line Type';
     Hint: 'Type of the program line in device';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'LineType';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TInDeviceLineType';
    ),
    (
     Caption: '1st param.';
     Hint: 'First script command line parameter';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Param1';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TScriptParam';
    ),
    (
     Caption: '2nd param.';
     Hint: 'Second script command line parameter';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Param2';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TScriptParam';
    ),
    (
     Caption: '3rd param.';
     Hint: 'Third script command line parameter';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Param3';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TScriptParam';
    ),
    (
     Caption: 'Note';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Note';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TPrgLineNote';
    ),
    (
     Caption: '';
     Hint: 'State of the program line';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4096;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 6;
     FieldColors : @FieldColors7;
     Filter: '';
     DefDir: '';
     StripPrefix: 'pls';
     EditMask: '';
     MaxID: 0;
     FieldName: 'State';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TPrgLineState';
    ),
    (
     Caption: 'Duration [min]';
     Hint: 'What time interval this program line should run';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 60.00;
     NumDec: 2;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Duration';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TAcqTime';
    )
  );

  USPDRecDesc: TULRecDesc = (
    Caption: 'Dev.Prg.Line';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 9;
    Flds: @USPDFldDescs;
    Flags: rfUsingColors OR rfEnabled OR rfEditModal OR rfVisible OR rfSortedByNumber;
    SortExp: 'PrgTime';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TUSPDObj}
function TUSPDObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TUSPDRec);
end;

constructor TUSPDObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), USPDID);
end;

function TUSPDObj.GetULRecDesc: PULRecDesc;
begin
  Result := @USPDRecDesc;
end;

function TUSPDObj.GetSortNum: Extended;
begin
  Result := PrgTime;
end;
procedure TUSPDObj.SetPrgTime(APrgTime: TAcqTime);
begin
  if PUSPDRec(Rec)^.PrgTime <> APrgTime then begin
    PUSPDRec(Rec)^.PrgTime := APrgTime;
    if USPDFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPDObj.GetPrgTime: TAcqTime;
begin
  GetPrgTime := PUSPDRec(Rec)^.PrgTime;
end;

procedure TUSPDObj.SetDeviceAlias(ADeviceAlias: string);
begin
  if PUSPDRec(Rec)^.DeviceAlias <> ADeviceAlias then begin
    PUSPDRec(Rec)^.DeviceAlias := ADeviceAlias;
    if USPDFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPDObj.GetDeviceAlias: string;
begin
  GetDeviceAlias := PUSPDRec(Rec)^.DeviceAlias;
end;

procedure TUSPDObj.SetLineType(ALineType: TInDeviceLineType);
begin
  if PUSPDRec(Rec)^.LineType <> ALineType then begin
    PUSPDRec(Rec)^.LineType := ALineType;
    if USPDFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPDObj.GetLineType: TInDeviceLineType;
begin
  GetLineType := PUSPDRec(Rec)^.LineType;
end;

procedure TUSPDObj.SetParam1(AParam1: TScriptParam);
begin
  if PUSPDRec(Rec)^.Param1 <> AParam1 then begin
    PUSPDRec(Rec)^.Param1 := AParam1;
    if USPDFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPDObj.GetParam1: TScriptParam;
begin
  GetParam1 := PUSPDRec(Rec)^.Param1;
end;

procedure TUSPDObj.SetParam2(AParam2: TScriptParam);
begin
  if PUSPDRec(Rec)^.Param2 <> AParam2 then begin
    PUSPDRec(Rec)^.Param2 := AParam2;
    if USPDFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPDObj.GetParam2: TScriptParam;
begin
  GetParam2 := PUSPDRec(Rec)^.Param2;
end;

procedure TUSPDObj.SetParam3(AParam3: TScriptParam);
begin
  if PUSPDRec(Rec)^.Param3 <> AParam3 then begin
    PUSPDRec(Rec)^.Param3 := AParam3;
    if USPDFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPDObj.GetParam3: TScriptParam;
begin
  GetParam3 := PUSPDRec(Rec)^.Param3;
end;

procedure TUSPDObj.SetNote(ANote: TPrgLineNote);
begin
  if PUSPDRec(Rec)^.Note <> ANote then begin
    PUSPDRec(Rec)^.Note := ANote;
    if USPDFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPDObj.GetNote: TPrgLineNote;
begin
  GetNote := PUSPDRec(Rec)^.Note;
end;

procedure TUSPDObj.SetState(AState: TPrgLineState);
begin
  if PUSPDRec(Rec)^.State <> AState then begin
    PUSPDRec(Rec)^.State := AState;
    if USPDFldDescs[7].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPDObj.GetState: TPrgLineState;
begin
  GetState := PUSPDRec(Rec)^.State;
end;

procedure TUSPDObj.SetDuration(ADuration: TAcqTime);
begin
  if PUSPDRec(Rec)^.Duration <> ADuration then begin
    PUSPDRec(Rec)^.Duration := ADuration;
    if USPDFldDescs[8].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPDObj.GetDuration: TAcqTime;
begin
  GetDuration := PUSPDRec(Rec)^.Duration;
end;

{/TUSPDObj}

end.
