unit USPEObju;
{ Generated by MakeComp 1.03 from USPETYPE.PAS. Don't modify manually !!! }
interface
uses Classes, SysUtils, Graphics, UlanType, ULRecTyp, ULObju, 
  USPEType;

type
  TUSPEObj = class(TULObj)
  protected
    function GetPrgEvent: TPrgEvent;
    procedure SetPrgEvent(APrgEvent: TPrgEvent);
    function GetCondition: TPrgEventCondition;
    procedure SetCondition(ACondition: TPrgEventCondition);
    function GetScript: TScriptName;
    procedure SetScript(AScript: TScriptName);
    function GetParam1: TScriptParam;
    procedure SetParam1(AParam1: TScriptParam);
    function GetParam2: TScriptParam;
    procedure SetParam2(AParam2: TScriptParam);
    function GetParam3: TScriptParam;
    procedure SetParam3(AParam3: TScriptParam);
    function GetNote: TPrgLineNote;
    procedure SetNote(ANote: TPrgLineNote);
    function GetState: TPrgLineState;
    procedure SetState(AState: TPrgLineState);
    function GetMinRecLen: TULRecLen; override;
  public
    constructor Create(AOwner:TULObj);
    function GetULRecDesc: PULRecDesc; override;
    function GetSortNum: extended; override;
  published
    property PrgEvent: TPrgEvent
      read GetPrgEvent write SetPrgEvent;
    property Condition: TPrgEventCondition
      read GetCondition write SetCondition;
    property Script: TScriptName
      read GetScript write SetScript;
    property Param1: TScriptParam
      read GetParam1 write SetParam1;
    property Param2: TScriptParam
      read GetParam2 write SetParam2;
    property Param3: TScriptParam
      read GetParam3 write SetParam3;
    property Note: TPrgLineNote
      read GetNote write SetNote;
    property State: TPrgLineState
      read GetState write SetState;
  end;

const
     FieldColors7 : array[0..5] of TULFieldColor = (
      (clBlack,clWhite),
      (clWhite,clGreen),
      (clBlack,clYellow),
      (clBlack,clGray),
      (clWhite,clRed),
      (clBlack,clWhite)
     );

  USPEFldDescs: array[0..7] of TULFldDesc = (
    (
     Caption: 'Event';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'PrgEvent';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TPrgEvent';
    ),
    (
     Caption: 'Condition';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: 'sc';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Condition';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TPrgEventCondition';
    ),
    (
     Caption: 'Script';
     Hint: 'Name of the script to be run at the Time';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4133;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: 'Scripts (*.IFS)|*.IFS';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Script';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TScriptName';
    ),
    (
     Caption: '1st param.';
     Hint: 'First script command line parameter';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Param1';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TScriptParam';
    ),
    (
     Caption: '2nd param.';
     Hint: 'Second script command line parameter';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Param2';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TScriptParam';
    ),
    (
     Caption: '3rd param.';
     Hint: 'Third script command line parameter';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Param3';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TScriptParam';
    ),
    (
     Caption: 'Note';
     Hint: '';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4097;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 0;
     FieldColors : nil;
     Filter: '';
     DefDir: '';
     StripPrefix: '';
     EditMask: '';
     MaxID: 0;
     FieldName: 'Note';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TPrgLineNote';
    ),
    (
     Caption: '';
     Hint: 'State of the program line';
     EditWidth: 0;
     BrowseWidth: 0;
     Flags: 4096;
     UserCoef: 0.00;
     NumDec: 0;
     ValuesSourceRecID: 0;
     FieldColorCount : 6;
     FieldColors : @FieldColors7;
     Filter: '';
     DefDir: '';
     StripPrefix: 'pls';
     EditMask: '';
     MaxID: 0;
     FieldName: 'State';
     KeyFieldName: '';
     ListFieldName: '';
     Typ: '';
     VarSize: false;
     PasType: 'TPrgLineState';
    )
  );

  USPERecDesc: TULRecDesc = (
    Caption: 'Prg.Event Line';
    ChildRecIDsStr: '';
    ChildRecIDs: nil;
    ChildRecIDCount: 0;
    FldCount: 8;
    Flds: @USPEFldDescs;
    Flags: rfUsingColors OR rfEnabled OR rfEditModal OR rfVisible OR rfSortedByNumber;
    SortExp: '-100000 + ord(PrgEvent)';
    EditFieldList: '';
    BrowseFieldList: '';
    MenuFieldList: '';
    BrowseChildRecIDs: '';
    NameProp: '';
    MainProp: '';
    DefDir: '';
    OpenFilter: '';
    SaveFilter: '';
    Table: '';
    Indexes: ''
   );

implementation

{TUSPEObj}
function TUSPEObj.GetMinRecLen: TULRecLen;
begin
  GetMinRecLen := sizeof(TUSPERec);
end;

constructor TUSPEObj.Create(AOwner: TULObj);
begin
  inherited Create(TComponent(AOwner), USPEID);
end;

function TUSPEObj.GetULRecDesc: PULRecDesc;
begin
  Result := @USPERecDesc;
end;

function TUSPEObj.GetSortNum: Extended;
begin
  Result := -100000 + ord(PrgEvent);
end;
procedure TUSPEObj.SetPrgEvent(APrgEvent: TPrgEvent);
begin
  if PUSPERec(Rec)^.PrgEvent <> APrgEvent then begin
    PUSPERec(Rec)^.PrgEvent := APrgEvent;
    if USPEFldDescs[0].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPEObj.GetPrgEvent: TPrgEvent;
begin
  GetPrgEvent := PUSPERec(Rec)^.PrgEvent;
end;

procedure TUSPEObj.SetCondition(ACondition: TPrgEventCondition);
begin
  if PUSPERec(Rec)^.Condition <> ACondition then begin
    PUSPERec(Rec)^.Condition := ACondition;
    if USPEFldDescs[1].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPEObj.GetCondition: TPrgEventCondition;
begin
  GetCondition := PUSPERec(Rec)^.Condition;
end;

procedure TUSPEObj.SetScript(AScript: TScriptName);
begin
  if PUSPERec(Rec)^.Script <> AScript then begin
    PUSPERec(Rec)^.Script := AScript;
    if USPEFldDescs[2].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPEObj.GetScript: TScriptName;
begin
  GetScript := PUSPERec(Rec)^.Script;
end;

procedure TUSPEObj.SetParam1(AParam1: TScriptParam);
begin
  if PUSPERec(Rec)^.Param1 <> AParam1 then begin
    PUSPERec(Rec)^.Param1 := AParam1;
    if USPEFldDescs[3].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPEObj.GetParam1: TScriptParam;
begin
  GetParam1 := PUSPERec(Rec)^.Param1;
end;

procedure TUSPEObj.SetParam2(AParam2: TScriptParam);
begin
  if PUSPERec(Rec)^.Param2 <> AParam2 then begin
    PUSPERec(Rec)^.Param2 := AParam2;
    if USPEFldDescs[4].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPEObj.GetParam2: TScriptParam;
begin
  GetParam2 := PUSPERec(Rec)^.Param2;
end;

procedure TUSPEObj.SetParam3(AParam3: TScriptParam);
begin
  if PUSPERec(Rec)^.Param3 <> AParam3 then begin
    PUSPERec(Rec)^.Param3 := AParam3;
    if USPEFldDescs[5].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPEObj.GetParam3: TScriptParam;
begin
  GetParam3 := PUSPERec(Rec)^.Param3;
end;

procedure TUSPEObj.SetNote(ANote: TPrgLineNote);
begin
  if PUSPERec(Rec)^.Note <> ANote then begin
    PUSPERec(Rec)^.Note := ANote;
    if USPEFldDescs[6].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPEObj.GetNote: TPrgLineNote;
begin
  GetNote := PUSPERec(Rec)^.Note;
end;

procedure TUSPEObj.SetState(AState: TPrgLineState);
begin
  if PUSPERec(Rec)^.State <> AState then begin
    PUSPERec(Rec)^.State := AState;
    if USPEFldDescs[7].VarSize then 
      ClearFieldsLen;
    DoChange;
  end;
end;

function TUSPEObj.GetState: TPrgLineState;
begin
  GetState := PUSPERec(Rec)^.State;
end;

{/TUSPEObj}

end.
