unit CuLDoCmdu;

interface
uses
  Windows, SysUtils, Classes, Forms,
  WinUtl, Attrib, ExeLogu, Pipes, Fileu,
  ULRecTyp,
  UlanType, UlanGlob, SpecForm, Channelsu;

procedure CuLDoCmd(const ACmd: shortstring; var AResult: shortstring);

procedure PipeServerStart;
implementation
type
  TCuLPipeServer = class(TPipeServer)
    procedure DoOnRead; override;
    constructor Create(AOwner: TComponent); override;
  end;

constructor TCuLPipeServer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  PipeName := CHROMuLANName;
  Active := true;
end;

procedure TCuLPipeServer.DoOnRead;
var
  r, s: shortstring;
  b: integer;
begin
  move(InBuf^, s[1], InBufCount);
  SetLength(s, InBufCount);
  CuLDoCmd(s, r);
  Write(r[1], length(r), b);
end;

procedure ChannelUpdate(const APars: shortstring; var AResult: shortstring);
var
  pars: TStringList;
  code: integer;
  sf: TSpectrumForm;
  fn: string;
  acqs, chs: string;
  chi, acqi: integer;
begin
  AResult := 'ER unknown error';
  sf := nil;
  pars := TStringList.Create;
  try
    { e.g.: p^ = 'channel=0 acq=0' }
    if APars <> '' then begin
      if not AttrLineToStrings(APars, pars) then begin
        AResult := 'ER invalid command attributes line';
        exit;
      end;
    end;
    chs := pars.Values['channel'];
    acqs := pars.Values['acq'];

    if acqs <> '' then begin
      val(acqs, acqi, code);
      if (code <> 0) or (acqi < acqMin) or (acqi > acqMax) then begin
        AResult := 'ER invalid value of attribute acq: ' + acqs;
        exit;
      end;
    end else
      acqi := 0;

    if chs <> '' then begin
      val(chs, chi, code);
      if (code <> 0) or (chi < 0) or (chi >= Channels.Count) then begin
        AResult := 'ER invalid value of attribute channel: ' + chs;
        exit;
      end;

      if FindSpecForm(chi, sf) then begin
        if acqi = acqStart then begin
          sf.RunButtonClick(nil);
        end else if acqi = acqStop then begin
          sf.StopButtonClick(nil);
        end;
      end else begin
        // no form for wanted channel
        if acqi <> acqStart then begin
          AResult := 'ER the channel is not running: ' + chs;
        end else begin
          fn := TemplateDir + Channels[chi].DefTemplateFileName;
          if not FileExists(fn) then begin
            AResult := 'ER template file not found: ' + fn;
            exit;
          end;
          sf := CreateSpectrumForm(fn, omCreate);{ulatype}
          Application.ProcessMessages;
          sf.RunButtonClick(nil);
        end;
      end;

      if sf <> nil then begin
        Application.ProcessMessages;
        fn := GetTempFileName;
        if sf.SaveSpectrumToBMP(fn) then begin
          AResult := 'OK ' + fn;
        end;
      end;

    end else begin
      AResult := 'OK';
    end;
  finally
    pars.Free;
  end;
end;

procedure CuLDoCmd(const ACmd: shortstring; var AResult: shortstring);
var
  cmd: string;
  pars: string;
  i: integer;
begin
  FInCuLDoCmd := true;
  try
    i := pos(' ', ACmd);
    if i <> 0 then begin
      cmd := copy(ACmd, 1, i - 1);
      pars := copy(ACmd, i + 1, length(ACmd));
    end else begin
      cmd := ACmd;
      pars := '';
    end;
    if cmd = 'channelupdate' then
      ChannelUpdate(pars, AResult);
  finally
    FInCuLDoCmd := false;
  end;
end;

var
  FCuLPipeServer: TCuLPipeServer = nil;

procedure PipeServerStart;
begin
  if OSVersion.dwPlatformId = VER_PLATFORM_WIN32_NT then begin
    try
      FCuLPipeServer := TCuLPipeServer.Create(nil);
    except
      on E: Exception do begin
        ExeLog.Log('CuLPipeServer Create Failed: ' + E.Message);
      end;
    end;
  end;//error
end;

initialization

finalization
  FCuLPipeServer.Free;
end.
