unit CuLSharedMemu;

interface
uses
  SharedMem, UlanType;

{ Return pointer to memory that can be shared by applications. }
function CuLSharedMem: PCuLSharedMem;

{ Return pointer to the next free shortstring memory slot usable
  as TMessage.LParam for exchanging informations between application }
function CuLSharedMemGetStr: PShortString;

implementation

var
  FSharedMem: TSharedMem;

function CuLSharedMem: PCuLSharedMem;
begin
  if FSharedMem = nil then begin
    FSharedMem := TSharedMem.Create(nil);
    FSharedMem.MemSize := sizeof(TCuLSharedMem);
    FSharedMem.MemName := CuLSharedMemName;
    FSharedMem.Active := true;
    PCuLSharedMem(FSharedMem.Mem)^.Size := sizeof(TCuLSharedMem);
  end;
  Result := PCuLSharedMem(FSharedMem.Mem);
end;


function CuLSharedMemGetStr: PShortString;
var
  sm: PCuLSharedMem;
  h: integer;
begin
  Result := nil;
  sm := CuLSharedMem;
  if sm = nil then
    exit;
  h := FSharedMem.Inc(@sm.Head, 1, CuLGlobalStringCount);
  Result := @sm.Strings[h];
end;

initialization
  FSharedMem := nil;
finalization
  FSharedMem.Free;
end.
