unit CulServMain;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, IdTCPServer, IdHTTPServer, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient, IdHTTP;

type
  TCulServMainForm = class(TForm)
    IdHTTPServer1: TIdHTTPServer;
    Memo: TMemo;
    procedure IdHTTPServer1CommandGet(AThread: TIdPeerThread;
      RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Log(msg: string);
  end;

var
  CulServMainForm: TCulServMainForm;

implementation

{$R *.xfm}

procedure TCulServMainForm.IdHTTPServer1CommandGet(AThread: TIdPeerThread;
  RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
begin
  Log(RequestInfo.Document + ' ' + RequestInfo.Command +
    ' ' + RequestInfo.UnparsedParams);

  ResponseInfo.WriteHeader;
  ResponseInfo.ContentText := '<html><head><title>CulServ response</title></head>' +
   '<body>Response from CulServ:<br />' +
   'Request was:<br />' +
   RequestInfo.Document + ' ' + RequestInfo.Command + ' ' + RequestInfo.UnparsedParams +
   '</body></html>';
  ResponseInfo.WriteContent;
end;

procedure TCulServMainForm.Log(msg: string);
begin
  Memo.Lines.Add(msg);
end;

end.
