unit DevSetFr;{ Form for basic setup }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}
{$I DEFINE.PAS}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin, PBSpinEdit, PBBinHexEdit,

  ULRecTyp, ULObju, ExtDevIntu, WinUtl,
  ModuType, UlanType,
  {$IFDEF USEDLL}
  ModuProc,
  {$ELSE}
  Modulu, UlDrvUtl, ULDriver, DevMode,
  {$ENDIF}
  Language, FileScanner;

type
  TDevSetupForm = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    DeviceModeGrpBox: TGroupBox;
    UlanRadioBtn: TRadioButton;
    ApexRadioBtn: TRadioButton;
    ExternalRadioBtn: TRadioButton;
    SysOpCheckBox: TCheckBox;
    PortNamePanel: TPanel;
    PortNameEdit: TEdit;
    PortNameLabel: TLabel;
    MaxWindowCountEdit: TSpinEdit;
    MaxChromWindowLabel: TLabel;
    DefAppComboBox: TComboBox;
    DefAppLbl: TLabel;
    LanguageLabel: TLabel;
    LanguageCheckBox: TCheckBox;
    LanguageComboBox: TComboBox;
    AutoFixDataCheckBox: TCheckBox;
    UlanButton: TButton;
    _OSVersionEdit: TEdit;
    SimulatingDataCheckBox: TCheckBox;
    AutoScanCheckBox: TCheckBox;
    ExportDecimalSeparatorComboBox: TComboBox;
    Label1: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ApexRadioBtnClick(Sender: TObject);
    procedure UlanRadioBtnClick(Sender: TObject);
    procedure ExternalRadioBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure UlanButtonClick(Sender: TObject);
  private
    { Private declarations }
    {v0.49}{/v0.49
    PresentInRegistry: boolean;}
      { .. entry for ul_drv.sys? }
    procedure DecideWhatToSee;
    procedure LanguageCheck;

    function GetCPortName: TPortName;
    procedure SetCPortName(APortName: TPortName);
    function GetCDevMode: TDeviceMode;
    procedure SetCDevMode(ADevMode: TDeviceMode);//ulanglob
    property CDeviceMode: TDeviceMode read GetCDevMode write SetCDevMode;
    property CPortName: TPortName read GetCPortName write SetCPortName;
  public
    { Public declarations }
  end;

var
  DevSetupForm: TDevSetupForm;

implementation
uses
  UlanGlob
  {$IFDEF USEDLL}
  {$ELSE}
  , ULDrvSetFrm
  {$ENDIF};

{$R *.DFM}

procedure TDevSetupForm.OKBtnClick(Sender: TObject);
{var}
  {v0.49}{v0.49
  chn:boolean;}
{v0.21}
{  br: integer;}
{/v0.21}
begin
  if UlanRadioBtn.Checked then begin
    CDeviceMode := dmUlan;
    {$IFDEF USEDLL}
    ModulesSetPropInt(Modules, mpDeviceMode, ord(CDeviceMode));
    ModulesSetPropInt(Modules, mpULDrvFailed, 0);
    {$ELSE}
    Modules.DeviceMode := CDeviceMode;
    Modules.ULDrvFailed := false;
    {$ENDIF}
  end else if ApexRadioBtn.Checked then
    CDeviceMode := dmPasive
  else if ExternalRadioBtn.Checked then
    CDeviceMode := dmExtDev;
  CPortName := PortNameEdit.Text;
  if SysOpCheckBox.Checked then
    UserMode := umSysOp
  else
    UserMode := umUser;

  with ExportDecimalSeparatorComboBox do begin
    ExportDecimalSeparator := Items[ItemIndex][1];
  end;

  MaxSpectrumFormCount := MaxWindowCountEdit.Value;
  DefaultApplication := DefAppComboBox.Text;
  {
  if LanguageCheckBox.Checked then begin
    LanguageInit(LanguageComboBox.Text);
    UseLanguage := true;
  end else begin
    LanguageDone;
    UseLanguage := false;
  end;}
  AutofixData := AutofixDataCheckBox.Checked;
  SimulatingData := SimulatingDataCheckBox.Checked;
  {$IFDEF USEDLL}
  ModulesSetPropInt(Modules, mpShouldAutoscanForModules, TModPropIntValue(AutoScanCheckBox.Checked));
  {$ELSE}
  ShouldAutoscanForModules := AutoScanCheckBox.Checked;
  {$ENDIF}
end;


procedure TDevSetupForm.FormActivate(Sender: TObject);
begin
  _OSVersionEdit.Text := GetOSVersion;{ulanglob modutype}
  {$IFDEF USEDLL}
  UlanRadioBtn.Enabled := boolean(ModulesGetPropInt(Modules, mpUlanModeAllowedByOS));
  {$ELSE}
  UlanRadioBtn.Enabled := UlanModeAllowedByOS;
  {$ENDIF}
  DecideWhatToSee;

  if (not UlanRadioBtn.Enabled) and (CDeviceMode = dmUlan) then
    CDeviceMode := dmUnspecified;

  case CDeviceMode of
    dmUlan: UlanRadioBtn.Checked := true;
    dmPasive: ApexRadioBtn.Checked := true;
    dmExtDev: ExternalRadioBtn.Checked := true;
  else
    ApexRadioBtn.Checked := true;
  end;
  SysOpCheckBox.Checked := (UserMode = umSysOp);
  PortNameEdit.Text := CPortName;

  MaxWindowCountEdit.Value := MaxSpectrumFormCount;
  DefAppComboBox.ItemIndex := DefAppComboBox.Items.IndexOf(DefaultApplication);
  AutofixDataCheckbox.Checked := AutofixData;
  SimulatingDataCheckBox.Checked := SimulatingData;
  {$IFDEF USEDLL}
  AutoScanCheckBox.Checked := boolean(ModulesGetPropInt(Modules, mpShouldAutoscanForModules));
  {$ELSE}
  AutoScanCheckBox.Checked := ShouldAutoscanForModules;
  {$ENDIF}
  with ExportDecimalSeparatorComboBox do begin
    ItemIndex := Items.IndexOf(ExportDecimalSeparator);
  end;
end;

procedure TDevSetupForm.LanguageCheck;
var
  f: TFileScanner;
  i: integer;
begin
  exit;
  f := TFileScanner.Create(nil);
  try
    f.Dir := ExtractFileDir(Application.ExeName);
    f.Mask := '*.lng';
    f.MakeList := true;
    f.ListFileNameParts := [fpName];
    f.Scan;
    LanguageCheckBox.Checked := FLanguage <> nil;
    LanguageComboBox.Items.Assign(f.List);
    for i := 0 to LanguageComboBox.Items.Count - 1 do begin
      if Uppercase(LanguageComboBox.Items[i]) = Uppercase(FLanguage.LanguageName) then begin
        LanguageComboBox.ItemIndex := i;
        break;
      end;
    end;
  finally
    f.Free;
  end;
end;

procedure TDevSetupForm.DecideWhatToSee;
begin
  if UlanRadioBtn.Checked then begin
    UlanButton.Visible := true;
    PortNamePanel.Visible := false;
  end else begin
    UlanButton.Visible := false;
    PortNamePanel.Visible := true;
  end;
  ExternalRadioBtn.Visible := (ExtDevs <> nil) and (ExtDevs.Count > 0);
end;

procedure TDevSetupForm.ApexRadioBtnClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TDevSetupForm.UlanRadioBtnClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TDevSetupForm.ExternalRadioBtnClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

procedure TDevSetupForm.FormShow(Sender: TObject);
begin
  LanguageCheck;
end;

procedure TDevSetupForm.UlanButtonClick(Sender: TObject);
begin
  {$IFDEF USEDLL}
  ModulesDoAction(Modules, msaULDrvSetupExecute, nil, 0);
  {$ELSE}
  ULDrvSetForm.ShowModal;
  {$ENDIF}
end;

function TDevSetupForm.GetCPortName: TPortName;
begin
  {$IFDEF USEDLL}
  Result := ModulesGetPropStr(Modules, mpCurPortName);
  {$ELSE}
  Result := CurPortName;
  {$ENDIF}
end;

procedure TDevSetupForm.SetCPortName(APortName: TPortName);
begin
  {$IFDEF USEDLL}
  ModulesSetPropStr(Modules, mpCurPortName, APortName);
  {$ELSE}
  CurPortName := APortName;
  {$ENDIF}
end;

function TDevSetupForm.GetCDevMode: TDeviceMode;
begin
  {$IFDEF USEDLL}
  Result := TDeviceMode(ModulesGetPropInt(Modules, mpCurDeviceMode));
  {$ELSE}
  Result := CurDeviceMode;
  {$ENDIF}
end;

procedure TDevSetupForm.SetCDevMode(ADevMode: TDeviceMode);//ulanglob
begin
  {$IFDEF USEDLL}
  ModulesSetPropInt(Modules, mpCurDeviceMode, ord(ADevMode));
  {$ELSE}
  CurDeviceMode := ADevMode;
  {$ENDIF}
end;

end.
