unit MenuBuilder;{v0.77}
interface
uses
  Classes, Menus; { TNotifyEvent }

type
   TScriptMenuItem = class(TMenuItem)
   private
     FScriptName: string;
   public
     property ScriptName: string read FScriptName write FScriptName;
   end;

{ Add TScriptMenuItem items to the AMenuItems' submenu using info in
  Menu_XXXX.ini file where for each item key=value the key is the ScriptName
  property of the ScriptMenuItem (i.e. the script to be called when the menu
  item with caption set to value is selected, the AEvent handler should
  call the script using the TScriptMenuItem(Sender).ScriptName property .
  XXXX is the code for the menu used. (XXXX='Application' used for the
  application menu, called from Main.pas) }
procedure ScriptMenuItemsAdd(AMenuItem: TMenuItem; const APrefix: string; AEvent: TNotifyEvent);

implementation

procedure ScriptMenuItemsAdd(AMenuItem: TMenuItem; const APrefix: string; AEvent: TNotifyEvent);
var
  l: TStrings;
  i: integer;
  n, v: string;
  mi: TScriptMenuItem;
begin
  l := TStringList.Create;
  try
    try
      l.LoadFromFile('Menu_'+ APrefix + '.ini');
      for i := 0 to l.Count - 1 do begin
        n := l.Names[i];
        v := l.Values[n];
        mi := TScriptMenuItem.Create(AMenuItem);
        AMenuItem.Add(mi);
        mi.Caption := v;
        mi.ScriptName := n;
        mi.OnClick := AEvent;
      end;
    except
      { The file does not have to be present }
    end;
  finally
    l.Free;
  end;
end;


end.
