unit ModFrm;
{$I DEFINE.PAS}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, ModuType,
  {$IFDEF USEDLL}
  ModuProc
  {$ELSE}
  Modulu
  {$ENDIF}
  ;

type
  TModuleForm = class(TForm)
    PropStringGrid: TStringGrid;
    CopyToModuleBtn: TButton;
    CopyToPCBtn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CopyToModuleBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Module:TModule;
    ShowUnnamedProps:boolean;
  end;

var
  ModuleForm: TModuleForm;

const
  CurModule:TModule = NoModule;
  { set by ulmain before TModuleForm.Create called }
{ciXXXX column indexes of fields}
const
  ciID = 0;
  ciDesc = 1;
  ciTypeDesc = 2;
  ciInModValue = 3;
  ciInPCValue = 4;
{/ciXXXX}

procedure ModuleFormShowCurrent;
  { shows (eventually creates) window that belongs to
    CurModule }
implementation

{$R *.DFM}
procedure ModuleFormShowCurrent;
var
  w:TModuleForm;
begin
  if CurModule <> NoModule then begin
    W := TModuleForm(CurModule.WinPtr);
    if W <> NoWinPtr then begin
      CurModule.WinPtr := nil;
      W.Module := nil;
      W.Release;
      Application.ProcessMessages;
    end;
    W := TModuleForm.Create(Application);
    CurModule.WinPtr := W;
    W.Module := CurModule;
   {end else
      W := TModuleForm(CurModule.WinPtr);}
    W.Show;
  end;
end;

procedure TModuleForm.FormCreate(Sender: TObject);
var
  prop:TModuleProp;
  rcnt, i:integer;
begin
  if CurModule = NoModule then
    exit;
  Module := CurModule;
  ShowUnnamedProps := false;
  with PropStringGrid do begin
    Cells[ciID, 0] := 'ID';
    Cells[ciDesc, 0] := 'Prop.name';
    Cells[ciTypeDesc, 0] := 'Prop.type';
    Cells[ciInPCValue, 0] := 'In PC val.';
    Cells[ciInModValue, 0] := 'In Mod. val.';

    if not ShowUnnamedProps then begin
      rcnt := 0;
      for i := 0 to CurModule.PropCount - 1 do begin
        if CurModule.GetProp(i, prop) and (prop.PropDesc <> '') then
          inc(rcnt);
      end;
      RowCount := rcnt + 1;
    end else begin
      RowCount := CurModule.PropCount + 1;
    end;

    rcnt := 0;
    for i := 0 to CurModule.PropCount - 1 do begin
      if CurModule.GetProp(i, prop) then begin
        if ShowUnnamedProps or (prop.PropDesc <> '') then begin
          inc(rcnt);
          Cells[ciID, rcnt] := IntToStr(prop.PropID);
          Cells[ciDesc, rcnt] := prop.PropDesc;
          Cells[ciTypeDesc, rcnt] := prop.TypeDesc;
          Cells[ciInModValue, rcnt] := prop.ModValStr;
        end;
      end;
    end;
  end;
end;

procedure TModuleForm.FormDestroy(Sender: TObject);
begin
  if Module <> NoModule then
    Module.WinPtr := NoWinPtr;
end;

procedure TModuleForm.CopyToModuleBtnClick(Sender: TObject);
var
  i:integer;
  id:TModulePropID;
  p:TModuleProp;
begin
  i := PropStringGrid.Row;
  if i > 0 then begin
    if Module <> NoModule then begin
      id := StrToInt(PropStringGrid.Cells[ciID, i]);
      if Module.FindProp(id, p) then begin
        if p.TypeID = ptCommand then
          p.Modified := true
        else
          p.PCValStr := PropStringGrid.Cells[ciInPCValue, i + 1];
        {odule.UploadPropVals;}
      end;
    end;
  end;
end;

end.
