{$I define.pas}
{$IFNDEF USEDLL} error {$ENDIF}
unit ModuGlob;

interface
uses
  Windows,
  IniFiles, UtlType, WinUtl, PropUtl, UlanType, ModuType;
const
{from ulanglob}
  DefPortName: shortstring = 'COM2';
    { what is the default port for communication }
  DefDeviceMode: TDeviceMode = dmUlan;
    { Set to dmUlan or dmApex, defines default type of
      communication with Pikron devices.
      dmUlan by default, if not running under NT/2000 get adjusted to
      dmApex after warning the user.
      Can be changed back in Setup|Options dialog.
      Copied to CurDeviceMode after reading from ini, CurDeviceMode
      is copied back to DefDeviceMode before writing to ini  }
  DefUVDetAddr:longint = 3;
    { What is the default address of UV detector in ulan network }

  { How many ulan device addresses should be scanned during autodetect. }
  MaxULAddr: integer = 20;

  PCUlanAddr: integer = 2;

  { Default baud rate to create ul_drv.req }
  UlanBaudRate: integer = $2580;{=9600}

  { Try to install ul_drv.sys automatically? Disable if makes troubles. }
  AutoConfigDriver: boolean = false;

  ULDrvStartType: TDevDrvStartType = stAuto;{default value; runtime retrieved from registry}

  PropertyLogging: boolean = true;

  { Should the detection of connected modules be run once after program starts? }
  ShouldAutoScanForModules: boolean = true;

  { Default serial port address used to create ul_drv.req }
  PortAddr: integer = $2f8;

  { Default irq used to create ul_drv.req }
  PortIrq: integer = 3;

  CurDeviceMode: TDeviceMode = dmUnspecified;
  CurPortName:shortstring = 'COM2';
  CurUVDetAddr:longint = 3;

var
  OSVersion:OSVERSIONINFO;

procedure ModuConfigReadWrite(rw:TReadWrite);

implementation

procedure ModuConfigReadWrite(rw:TReadWrite);
var f: TIniFile;
begin
  if rw = rwWrite then begin
    DefDeviceMode := CurDeviceMode;
    DefPortName := CurPortName;
    DefUVDetAddr := CurUVDetAddr;
  end;
  f := TIniFile.Create(FindIniFile);
  try
    ConfigReadWriteValue(f, rw, DevSection, 'DefPortName', @DefPortName, ptString);
    ConfigReadWriteValue(f, rw, DevSection, 'DevMode', @DefDeviceMode, ptByte);
    ConfigReadWriteValue(f, rw, DevSection, 'UVDetAddr', @DefUVDetAddr, ptLongint);

    ConfigReadWriteValue(f, rw, DevSection, 'MaxULAddr', @MaxULAddr, ptLongint);
    ConfigReadWriteValue(f, rw, DevSection, 'AutoConfigDriver', @AutoConfigDriver, ptByte);
    ConfigReadWriteValue(f, rw, EnvSectionName, 'ShouldAutoScanForModules', @ShouldAutoScanForModules, ptByte);
    ConfigReadWriteValue(f, rw, EnvSectionName, 'PropertyLogging', @PropertyLogging, ptByte);

    if rw = rwRead then begin
      CurDeviceMode := DefDeviceMode;
      CurPortName := DefPortName;
      CurUVDetAddr := DefUVDetAddr;
    end;
  finally
    f.Free;
  end;
end;


initialization
  OSVersion.dwOSVersionInfoSize := sizeof(OSVersion);
  GetVersionEx(OSVersion);
end.
