unit ULDrvSetFrm;{v0.49}{ Form for interactive setup of UL_DRV driver }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

{$I define.pas}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, PBSpinEdit, PBBinHexEdit, ExtCtrls,
  UtlType, ULRecTyp, ULObju, {$IFDEF USEDLL}ModuGlob,{$ELSE} UlanGlob,{$ENDIF}
  ModuType, ULDrvTyp,
  Modulu, UlDrvUtl, ULDriver, //modules\uldriver modules\uldrvutl
  DevMode,
  DevDrv;

const {from drvtool}
  oiDevName = 1;
  oiLoad = 2;
  oiStart = 3;
  oiKill = 4;
  oiUnload = 5;
  oiQuery = 6;
  oiHelp = 7;

type
  TULDrvSetForm = class(TForm)
    OKButton: TButton;
    UlanPanel: TPanel;
    Label1: TLabel;
    IrqLabel: TLabel;
    UlanBaudRateLabel: TLabel;
    PortAddrEdit: TPBBinHexEdit;
    PortIrqEdit: TPBSpinEdit;
    AutoConfigCheckBox: TCheckBox;
    UlanBaudRateComboBox: TComboBox;
    CancelButton: TButton;
    LoadButton: TButton;
    Label2: TLabel;
    StartButton: TButton;
    StopButton: TButton;
    UnloadButton: TButton;
    TestPanel: TPanel;
    LogMemo: TMemo;
    StartTypeComboBox: TComboBox;
    Label3: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure UnloadButtonClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    PresentInRegistry: boolean;
    FULDrv: TULDriver;
    FDrv: TDevDrv;
    procedure CheckRegistry;
    procedure FormToVar;
    procedure Run(oi: integer);
    procedure Log(const msg: string);
  public
    { Public declarations }
  end;

const
  ULDrvSetForm: TULDrvSetForm = nil;

procedure ULDrvSetupExecute;

implementation

{$R *.DFM}

procedure TULDrvSetForm.CheckRegistry;
begin
  if not PresentInRegistry then
    FormToVar;
end;

procedure TULDrvSetForm.FormToVar;
var
{ chn: boolean; }
  br: integer;
begin
  {chn := false;}
  if PortAddr <> PortAddrEdit.AsInteger then begin
    PortAddr := PortAddrEdit.AsInteger;
    {chn := true;}
  end;
  if PortIrq  <> PortIrqEdit.Value then begin
    PortIrq := PortIrqEdit.Value;
    {chn := true;}
  end;
  br := StrToInt(UlanBaudRateComboBox.Text);
  if br <> UlanBaudRate then begin
    UlanBaudRate := br;
    {chn := true;}
  end;
  {v0.49}
  ULDrvStartType := TDevDrvStartType(StartTypeComboBox.ItemIndex);
  {/v0.49}
  {if chn or (not PresentInRegistry) then}
  begin
    ULDrvReqReadWrite(false, PortAddr, PortIrq, PCUlanAddr, UlanBaudRate{v0.49}, ULDrvStartType{/v0.49});
  end;
  AutoConfigDriver := AutoConfigCheckBox.Checked;
end;

procedure TULDrvSetForm.OKButtonClick(Sender: TObject);
begin
  FormToVar;
end;

procedure TULDrvSetForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  FULDrv := Modules.ULDrv;
  if FULDrv <> nil then begin
    {v0.49}
    ULDrvReqReadWrite(true, PortAddr, PortIrq, PCUlanAddr,
        UlanBaudRate, ULDrvStartType);
    {/v0.49}
    PortAddr := FULDrv.PortAddr;
    PortIrq := FULDrv.PortIrq;
    UlanBaudRate := FULDrv.BaudRate;

    PresentInRegistry := true;
    if FULDrv.InstanceCount = 1 then
    begin
      Modules.ULDrvLock;
      Modules.ULDrvFree;
      TestPanel.Visible := true;
    end else begin
      TestPanel.Visible := false;
    end;
  end else begin
    PresentInRegistry :=
      ULDrvReqReadWrite(true, PortAddr, PortIrq, PCUlanAddr,
        UlanBaudRate{v0.49}, ULDrvStartType{/v0.49}) = 0;
    TestPanel.Visible := true;
  end;
  PortAddrEdit.AsInteger := PortAddr;
  PortIrqEdit.Value := PortIrq;
  AutoConfigCheckBox.Checked := AutoConfigDriver;
  UlanBaudRateComboBox.ItemIndex := 3;
  for i := 0 to UlanBaudRateComboBox.Items.Count - 1 do begin
    if StrToInt(UlanBaudRateComboBox.Items[i]) = UlanBaudRate then begin
     UlanBaudRateComboBox.ItemIndex := i;
     break;
    end;
  end;
  {v0.49}
  StartTypeComboBox.ItemIndex := ord(ULDrvStartType);
  {/v0.49}
  if TestPanel.Visible then begin
    FDrv := TDevDrv.Create(UL_DEV_NAME,0);
    LogMemo.Lines.Clear;
  end;
end;

procedure TULDrvSetForm.FormDeactivate(Sender: TObject);
begin
  if Modules.ULDrvLocked then
    Modules.ULDrvUnlock;
  FDrv.Free;
  FDrv := nil;
end;


procedure TULDrvSetForm.Log(const msg: string);
begin
  LogMemo.Lines.Add(msg);
end;

procedure TULDrvSetForm.Run(oi: integer);
var
  r: integer;
  state: DWORD;
  {unloaded: boolean;}

  procedure LogRes(msg:string; r: integer);
  begin
    if r <> 0 then
      Log(msg + ': ' + FDrv.ErrorLookup(r))
    else
      Log(msg + ': OK');
    Run(oiQuery);
  end;

begin
  case oi of
    oiQuery: begin
      r := FDrv.GetState(state);
      if r = 0 then
        Log('Driver state: ' + FDrv.GetStateMsg(state))
      else
        Log('Error getting driver state');
    end;
    oiLoad: begin
      CheckRegistry;
      r := FDrv.CheckDeviceLoaded;
      LogRes('Load', r);               {getlasterror}
    end;
    oiStart: begin
      r := FDrv.CheckDeviceStarted;
      LogRes('Start', r);
    end;
    oiKill: begin
       r := FDrv.CheckDeviceStopped(true, false);
       LogRes('Stop', r);
    end;
    oiUnload: begin
      r := FDrv.CheckDeviceUnloaded;
      if r = 0 then
        PresentInRegistry := false;
      LogRes('Unload', r);
    end;
  end;
end;

procedure TULDrvSetForm.LoadButtonClick(Sender: TObject);
begin
  Run(oiLoad);
end;

procedure TULDrvSetForm.StartButtonClick(Sender: TObject);
begin
  Run(oiStart);
end;

procedure TULDrvSetForm.StopButtonClick(Sender: TObject);
begin
  Run(oiKill);
end;

procedure TULDrvSetForm.UnloadButtonClick(Sender: TObject);
begin
  Run(oiUnload);
end;

procedure ULDrvSetupExecute;
begin
  if ULDrvSetForm = nil then
    Application.CreateForm(TULDrvSetForm, ULDrvSetForm);
  ULDrvSetForm.ShowModal;
end;


procedure TULDrvSetForm.FormDestroy(Sender: TObject);
begin
  ULDrvSetForm := nil;
end;

end.
