unit ProcessFrm;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  UtlType, ULRecTyp, ULObju, Processoru, ULObjCtrl;

type
  TProcessForm = class(TForm)
    SequenceButton: TButton;
    RunButton: TButton;
    StopButton: TButton;
    SequenceStateEdit: TEdit;
    Label1: TLabel;
    ActivePrgTimeEdit: TEdit;
    Label2: TLabel;
    ProgramButton: TButton;
    SequenceStateCtrl: TULObjCtrl;
    ActiveSampleCtrl: TULObjCtrl;
    ActivePrgTimeCtrl: TULObjCtrl;
    ActiveSampleEdit: TEdit;
    SampleLabel: TLabel;
    SequenceNameEdit: TEdit;
    Label3: TLabel;
    SequenceNameCtrl: TULObjCtrl;
    SampleButton: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure SequenceButtonClick(Sender: TObject);
    procedure RunButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure ProgramButtonClick(Sender: TObject);
    procedure SampleButtonClick(Sender: TObject);
  private
    { Private declarations }
    FProcessor: TProcessor;
    procedure SetProcessor(AProcessor: TProcessor);
    procedure WMAppMessage(var Message:TMessage);message WM_APPMESSAGE;
    procedure ProcessorUpdated;
  public
    { Public declarations }
    property Processor: TProcessor read FProcessor write SetProcessor;
  end;

var
  ProcessForm: TProcessForm;

implementation
{$R *.DFM}

procedure TProcessForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if (FProcessor <> nil) and FProcessor.Running then
    Action := caMinimize
  else
    Action := caFree;
end;

procedure TProcessForm.SetProcessor(AProcessor: TProcessor);
{v0.52}
  procedure UpdateULObjPath(const APath: string);
  var
    i: integer;
    c: TComponent;
  begin
    for i := 0 to ComponentCount - 1 do begin
      c := Components[i];
      if c is TULObjCtrl then with c as TULObjCtrl do begin
        ULObjPath := FProcessor.Obj.ULObjPath;
      end;
    end;
  end;
{/v0.52}

begin
  if FProcessor = AProcessor then
    exit;
  if FProcessor <> nil then begin
    FProcessor.Obj.UserUnregister(Self);
    {v0.52}
    UpdateULObjPath('');
    {/v0.52}
  end;

  FProcessor := AProcessor;

  if FProcessor = nil then begin
    if not (csDestroying in ComponentState) then
      Release
  end else begin
    FProcessor.Obj.UserRegister(Self);
    {v0.52}
    UpdateULObjPath(FProcessor.Obj.ULObjPath);
    Caption := FProcessor.UPO.ProcessorName;
    {/v0.52}
  end;
end;

procedure TProcessForm.FormDestroy(Sender: TObject);
begin
  if Processor <> nil then begin
    Processor.FormClear;
    Processor := nil;
  end;
end;

procedure TProcessForm.ProcessorUpdated;
begin
  if Processor <> nil then with Processor do begin
    SequenceButton.Enabled := Sequence <> nil;
    SampleButton.Enabled := CurSample <> nil;
    ProgramButton.Enabled := CurPrg <> nil;
  end;
end;

procedure TProcessForm.WMAppMessage(var Message:TMessage);
begin
  case Message.WParam of
    cmULObjUpdated: begin
      if TULObj(Message.LParam) = FProcessor.Obj then
        ProcessorUpdated;
    end;
    cmULObjDestroyed: begin
      if TULObj(Message.LParam) = FProcessor.Obj then begin
        Processor := nil;
      end;
    end;
  end;
  inherited;
end;

procedure TProcessForm.SequenceButtonClick(Sender: TObject);
begin
  if FProcessor <> nil then
    FProcessor.SequenceBrowse(Sender);
end;

procedure TProcessForm.RunButtonClick(Sender: TObject);
begin
  if FProcessor <> nil then
    FProcessor.SequenceRun(Sender);
end;

procedure TProcessForm.StopButtonClick(Sender: TObject);
begin
  if FProcessor <> nil then
    FProcessor.SequenceStopRunning(Sender);
end;

procedure TProcessForm.ProgramButtonClick(Sender: TObject);
begin
  if FProcessor <> nil then
    FProcessor.ShowActPrgAction(Sender);;
end;

procedure TProcessForm.SampleButtonClick(Sender: TObject);
begin
  if FProcessor <> nil then
    Processor.DoAcqShow(Sender);
end;

end.
