unit ULMaGlob;{ Chromulan initialization/deinitialization global procedures }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}
{$I define.pas}
interface
uses
  Classes, Forms, SysUtils,
  UtlType, WinUtl, ExeLogu,
  ModuType,
  {$IFDEF USEDLL}
  ModuProc,
  {$ELSE}
  ul_lcabs, ULDrvTyp, ULDriver,
  DrvLogu, Modulu,
  {$ENDIF}
  ExtDevIntu,
  UlanGlob, Channelsu, AAAu, Processoru, CuLDoCmdu;

const
{ini.lst}
  {UVDetAddr:longint = 3;}
    { ulan device address of UV detector }
  UVDetSII:PScanInputInfo = nil;
    { handle for receiving data from UV detector }
{/ini.lst}
  IsInTimer:boolean = false;
    { recursion preventer for ulMDoTimer event }


function ulMInit(InitRcv:boolean):boolean;
  { ulMaster initialization, called from ulMaster main window create,
    opens ini file, opens log files }

function ulMDoTimer:boolean;
  { timer triggered method }

function ulMDone:boolean;
  { ulMaster deinitialization, called from ulMaster main window destroy,
    closes log files, ini file }

implementation

{const
  GlobalVars: PVarRecordArray = nil;}
  //modules\modulu
function ulMInit(InitRcv:boolean):boolean;
begin
  UlanConfigReadWrite(rwRead);
  {$IFDEF USEDLL}
  {$ELSE}
  DrvLogInit;
  ExtDevs := TExtDevs.Create;
  {$ENDIF}
  {$IFDEF USEDLL}
  ModulesCreate(Modules);
  ModulesSetPropInt(Modules, mpApplication, Integer(Application));
  ExtDevs := TExtDevs(ModulesGetPropInt(Modules, mpExtDevs));
  {$ELSE}
  Modules := TModules.Create;
  {$ENDIF}
  Channels := TChannels.Create;
  if InitRcv then begin
    {$IFDEF USEDLL}
    RcvInit(UVDetSII, IntToStr(ModulesGetPropInt(Modules, mpUVDetAddr)));
    {$ELSE}
    RcvInit(UVDetSII, IntToStr(CurUVDetAddr));
    {$ENDIF}
  end;
  if StartPipeServer then begin
    CuLDoCmdu.PipeServerStart;
  end;
  ulMInit := true;
end;


function ulMDoTimer:boolean;
begin
  ulMDoTimer := false;
  if IsInTimer then begin
    ExeLog.Log('ulmaglob.ulMDoTimer tried to call recursively');
    exit;
  end;
  try
    IsInTimer := true;
    if Modules <> nil then begin
      {$IFDEF USEDLL}
      ModulesDoTimer(Modules);
      {$ELSE}
      Modules.DoTimer;
      {$ENDIF}
    end;
    RcvRun(UVDetSII);
    ulMDoTimer := true;
  finally
    IsInTimer := false;
  end;
end;

function ulMDone:boolean;
begin
  AAAFree;
  UlanConfigReadWrite(rwWrite);
  RcvDone(UVDetSII);
  ProcessorsFree;
  ClassFree(Channels);
  {$IFDEF USEDLL}
  ModulesDestroy(Modules);
  {$ELSE}
  ClassFree(Modules);
  ClassFree(ExtDevs);
  DrvLogDone;
  {$ENDIF}
  ulMDone := true;
end;

end.
