unit ULBrowseFrm;{v0.24}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Grids, ExtCtrls, Menus, Clipbrd, ActnList, 
  UtlType, PropUtl, ExeLogu,
  ULRecTyp, ULRecUtl, ULObju, ULObjDes,
  XStringGrid, XStringGridRegister, XSAbout,
  CECheckList, CEForm, CEFormRegister, CEButton,
  ULStringGrid;
{ulrectyp}
type
  TULBrowseForm = class(TForm)
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  protected
    FGrid: TULStringGrid;
    FActivated: boolean;
    procedure WMAppMessage(var Msg: TMessage); message WM_APPMESSAGE;
    {v0.44}
    procedure FrmActivate;
    procedure FrmDeactivate;
    {/v0.44}
    {v0.61}
    procedure DoOnDblClick(Sender: TObject);
    {/v0.61}
  public
  end;

var
  ULBrowseForm: TULBrowseForm;

implementation

{$R *.DFM}

procedure TULBrowseForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TULBrowseForm.FormCreate(Sender: TObject);
begin
  FGrid := TULStringGrid.Create(Self);
  {v0.50}
  FGrid.CloseFormOnObjDestroy := true;
  {/v0.50}
  FGrid.Align := alClient;
  FGrid.Parent := Self;
  FGrid.ShowHint := true;
  {v0.61}
  {v0.69}
  if (not Assigned(FGrid.OnDblClick)) or FBrowsingForChild then
  {/v0.69}
    FGrid.OnDblClick := DoOnDblClick;
  {/v0.61}
end;

{v0.61}
procedure TULBrowseForm.DoOnDblClick(Sender: TObject);
begin
  if FBrowsingForChild then begin
    ModalResult := mrOK;
  end;
end;
{/v0.61}

{uledfrm}
procedure TULBrowseForm.WMAppMessage(var Msg: TMessage);
begin
  case Msg.WParam of
    cmQueryEditMenu: FGrid.WMAppMessage(Msg);
  end;
end;

procedure TULBrowseForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  {v0.25}
  if (FGrid <> nil) and (FGrid.Obj <> nil) then
    CanClose := FGrid.Obj.CanClose{v0.31}(FGrid){/v0.31};
  {/v0.25}
end;

{v0.44}
procedure TULBrowseForm.FrmActivate;
begin
  if FActivated then
    exit;
  FActivated := true;
  if (FGrid <> nil) and (FGrid.Obj <> nil) then begin
    CurULStringGrid := FGrid;
    FGrid.Obj.UsersNotify(cmULObjULGridFormActivated);
  end;
end;
{/v0.44}

procedure TULBrowseForm.FormActivate(Sender: TObject);
begin
  FrmActivate;
end;

procedure TULBrowseForm.FormDeactivate(Sender: TObject);
begin
  {v0.44}
  FrmDeactivate;
  {/v0.44}
end;


{v0.44}
procedure TULBrowseForm.FrmDeactivate;
begin
  if not FActivated then
    exit;
  FActivated := false;
  if (FGrid <> nil) and (FGrid.Obj <> nil) then begin
    CurULStringGrid := FGrid;
    FGrid.Obj.UsersNotify(cmULObjULGridFormDeactivated);
  end;
end;
{/v0.44}

procedure TULBrowseForm.FormDestroy(Sender: TObject);
begin
  {v0.44}
  FrmDeactivate;
  {/v0.44}
end;

end.
