unit ULKeepFrm;{ Form showing list of all open ULObj files }
{
  (C) 2000 - 2002 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ULObju, StdCtrls;

type
  TULKeeperForm = class(TForm)
    ListBox: TListBox;
    procedure ListBoxClick(Sender: TObject);
    procedure ListBoxKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormActivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    procedure UpdateList;
    procedure Browse;
  public
    { Public declarations }
  end;

function ULKeeperForm: TULKeeperForm;

const
  FULKeeperForm: TULKeeperForm = nil;

implementation

{$R *.DFM}

function ULKeeperForm: TULKeeperForm;
begin
  if FULKeeperForm = nil then
    FULKeeperForm := TULKeeperForm.Create(Application);
  Result := FULKeeperForm;
end;

procedure TULKeeperForm.ListBoxClick(Sender: TObject);
begin
  Browse;
end;

procedure TULKeeperForm.Browse;
var
  o: TULObj;
  i: integer;
begin
  i := ListBox.ItemIndex;
  if i < 0 then
    exit;
  o := TULObj(ListBox.Items.Objects[i]);{ulobju }
  if o.ChildCount > 0 then
    o.Childs[0].Edit;
end;


procedure TULKeeperForm.ListBoxKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    vk_Escape: Release;
    vk_Return: Browse;
  end;
end;

procedure TULKeeperForm.UpdateList;
var
  o: TULObj;
  i: integer;
begin
  ListBox.Items.Clear;
  for i := 0 to ULFKeeper.Count - 1 do begin
    o := TULObj(ULFKeeper.Items[i]);
    ListBox.Items.AddObject(o.FileName, o);
  end;
end;
procedure TULKeeperForm.FormActivate(Sender: TObject);
begin
  UpdateList;
end;

procedure TULKeeperForm.FormDestroy(Sender: TObject);
begin
  FULKeeperForm := nil;
end;

end.
