unit ULObjEditPanelu;
{
  (C) 2000 - 2002 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

{ Panel for editing ULObj properties }
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,

  UtlType, PropUtl, WinUtl, BtnEdit,

  ULRecTyp, ULObju, ULEdUtl;

{!! SEE ULObjAct.ChildBtnEditClick for editing the values from ULStringGrid }

type
  TULObjEditPanel = class(TPanel)
  private
    { Private declarations }
  protected
    FOKBtn: TButton;
    FCancelBtn: TButton;
    {FParamBtn: TButton;}
    FObjRootFileDir: string;
      { Path of the file from which is the Obj,
        used to create relative filenames set to Text properties. }
    FInfo:longint;
    FModified: boolean;
    FObj: TULObj;
    { Copy values of visual edit components to properties of Obj TULObj }
    procedure ComponentsToObj;virtual;
    { Copy values of properties of Obj TULObj to visual edit components }
    procedure ObjToComponents(AlsoToFocused:boolean);virtual;
    procedure FindBtns;
    procedure CMChanged(var Msg:TCMChanged);message CM_CHANGED;
    procedure BtnEditClick(Sender: TObject);
    procedure SetObj(AObj: TULObj);
    function GetObj: TULObj;
    procedure FindBtnEdits;
    procedure SetModified(OnOff: boolean);virtual;
  public
    { Public declarations }
    procedure Rebuild;

    procedure WMAppMessage(var Msg: TMessage); message WM_APPMESSAGE;
    procedure WMCommand(var Msg: TWMCommand); message WM_COMMAND;
    procedure WMKeyDown(var Msg: TWMKey); message WM_KEYDOWN;{windows messages}
    procedure WndProc(var Message: TMessage); override;
    constructor Create(AOwner: TComponent); reintroduce;
    destructor Destroy; override;
    {function CloseQuery: boolean; override;}

    procedure DoOnOK;
    procedure DoOnCancel;
    {procedure DoOnParam;}

    property Modified: boolean read FModified write SetModified;
    property Obj: TULObj read GetObj write SetObj;
  end;

{v0.64}
procedure Register;
{/v0.64}

implementation

constructor TULObjEditPanel.Create(AOwner: TComponent);
var
  o: TULObj;
begin
  inherited Create(AOwner);
  {v0.25}
  if CurULObj <> nil then
  {/v0.25}
  begin
    o := CurULObj;
    CurULObj := nil;
    Obj := o;
  end;
{  KeyPreview := true;}

  {v0.24}
  {v0.47 moved to form activate}
  {/v0.47
  for i := 0 to ControlCount - 1 do begin
    c := Controls[i];
    if c is TBtnEdit then begin
      TBtnEdit(c).OnBtnClick := BtnEditClick;
      TBtnEdit(c).EmptyAllowed := true;
    end;
  end;}
  {/v0.24}
end;

procedure TULObjEditPanel.ObjToComponents(AlsoToFocused:boolean);{language}
begin
  if not AlsoToFocused then begin
    ULObjToWinControl(Obj, Self, [foCaption, foExcludeFocused], FObjRootFileDir)
  end else begin
    ULObjToWinControl(Obj, Self, [foCaption], FObjRootFileDir)
  end;
  FModified := false;
end;

procedure TULObjEditPanel.FindBtns;
var
  c: TComponent;
  i: integer;
begin
  for i := 0 to ComponentCount - 1 do begin
    c := Components[i];
    if c is TButton then with c as TButton do begin
      if ModalResult = mrOK then
        FOKBtn := TButton(c);
      if ModalResult = mrCancel then
        FCancelBtn := TButton(c);
      {if c.Name = 'ParamsBtn' then begin
        FParamBtn := TButton(c);
      end;}
    end;
  end;
end;

procedure TULObjEditPanel.ComponentsToObj;
begin
  WinControlToULObj(Self, Obj, [foCaption], FObjRootFileDir);
  Modified := false;
end;

procedure TULObjEditPanel.WndProc(var Message: TMessage);
begin
  case Message.Msg of
    WM_CHAR, WM_KeyDown{, WM_SYSKEYDOWN, WM_COMMAND, WM_SYSCOMMAND}: begin
      if Message.WParam = vk_Return then begin
        Message.Result := 0;
        PostMessage(Handle, WM_Command, 0, FOKBtn.Handle);
      end;
    end;
  end;
  inherited;
end;

procedure TULObjEditPanel.WMKeyDown(var Msg: TWMKey);
begin
  if Msg.CharCode = vk_Return then begin
    Msg.Result := 0;
    PostMessage(Handle, WM_Command, 0, FOKBtn.Handle);
  end;
end;

procedure TULObjEditPanel.WMCommand(var Msg: TWMCommand);
begin
  if Msg.NotifyCode = 0 then begin
    if (FOKBtn <> nil) and (FOKBtn.Handle = Msg.Ctl) then begin
      DoOnOK;
    end;
    if (FCancelBtn <> nil) and (FCancelBtn.Handle = Msg.Ctl) then begin
      DoOnCancel;
    end;
    {if (FParamBtn <> nil) and (FParamBtn.Handle = Msg.Ctl) then begin
      DoOnParam;
    end;}
  end;
  inherited;
end;

procedure TULObjEditPanel.DoOnOK;
begin
  ComponentsToObj;
  {
  if not (fsModal in FormState) then begin
    if Obj <> nil then begin
      ComponentsToObj;
      SetObj(nil);
    end;
    Release;
  end;
  ModalResult := mrOK;
  }
end;

procedure TULObjEditPanel.DoOnCancel;
{var o:TULObj;}
begin
  ObjToComponents(true);
  {
  if not (fsModal in FormState) then begin
    ObjToComponents(true);
    if (Obj <> nil) and Obj.JustCreated then begin
      o := Obj;
      SetObj(nil);
      o.Free;
    end;
    Release;
  end;
  }
end;

{
procedure TULObjEditPanel.DoOnParam;
begin
  if Obj <> nil then begin
    ComponentsToObj;
    Obj.Browse;
  end;
end;
}
procedure TULObjEditPanel.WMAppMessage(var Msg: TMessage);
begin
  case Msg.wParam of

    cmULObjCanDestroy: begin
    end;

    cmULObjUpdated: begin
      if TULObj(Msg.lParam) = Obj then begin
        if not Modified then
          ObjToComponents(false);
      end;
    end;

    cmULObjDestroyed: begin
      if TULObj(Msg.lParam) = Obj then begin
        SetObj(nil);
        Release;
      end;
    end;

    cmULObjEditFormBringToFront: begin
      if TULObj(Msg.lParam) = Obj then begin
        Msg.Result := 1;
        BringToFront;
      end;
    end;
  end;
end;

procedure TULObjEditPanel.SetObj(AObj: TULObj);
begin
  if AObj = FObj then
    exit;
  if FObj <> nil then begin
    FObj.UserUnregister(Self);
  end;
  FObj := AObj;
  if FObj <> nil then begin
    FObj.UserRegister(Self);
    FObjRootFileDir := FObj.RootFileDir;
  end else begin
    FObjRootFileDir := '';
  end;

  Rebuild;
end;

destructor TULObjEditPanel.Destroy;
begin
  Obj := nil;
  inherited Destroy;
end;

(*
function TULObjEditPanel.CloseQuery: boolean;
begin
  {$IFNDEF CONSOLE}
  if (ModalResult = mrOK) and (Obj <> nil) then begin
    Result := (Obj.IsValidInput(Self));
    if Result then begin
      Result := (SendMessage(Application.MainForm.Handle, WM_APPMESSAGE, cmULEditFormCloseQuery,
        longint(Self)) = 0);
      if Result then begin
        ComponentsToObj;
      end;
    end;
  end else begin
    Result := inherited CloseQuery;
  end;
  {$ENDIF}
end;
*)

procedure TULObjEditPanel.FindBtnEdits;
var
  i: integer;
  c: TControl;
begin
  for i := 0 to ControlCount - 1 do begin
    c := Controls[i];
    if c is TBtnEdit then begin
      TBtnEdit(c).OnBtnClick := BtnEditClick;
      TBtnEdit(c).EmptyAllowed := true;
    end;
  end;
end;

procedure TULObjEditPanel.Rebuild;
begin
  DestroyComponents;
  if FObj <> nil then
    FObj.ObjDesc.EditControlFill(Self, FObj);
  FindBtnEdits;
  ObjToComponents(true);
  FindBtns;
{  KeyPreview := true;}
end;

procedure TULObjEditPanel.BtnEditClick(Sender: TObject);
var
  e: TBtnEdit;
  f: TULObjField;
  s: string;
  d: string;
  ext: string;
  n: string;
  l: integer;
begin
  e := TBtnEdit(TButton(Sender).Owner);
  f := Obj.Fields[e.Tag];
  if f.FldDesc.IsFileName then begin
    f.DefDirNeeded;
    FileNameSplit(e.Text, d, n, ext);
    if d = '' then begin
      d := f.FldDesc.DefDir;
      if d = '' then
        d := FObjRootFileDir;
    end;
    if ext = '' then
      ext := f.FldDesc.DefExt;
    s := AbsoluteFileName(d, n, ext);
    if f.FieldFileNameOpenSelect(s) then begin
      e.Text := RelativeFileName(d, s, ext);
    end;
  end else if f.FldDesc.IsDir then begin
    s := e.Text;
    if f.DirSelect(s) then begin
      e.Text := s;
    end;
  end else if f.FldDesc.IsSetType then begin
    if e.Text = '' then
      l := 0
    else
      l := StrToInt(e.Text);
    if f.FldDesc.CheckListBoxFormExecute(l) then begin
      e.Text := IntToStr(l);
    end;
  end;
end;

procedure TULObjEditPanel.CMChanged(var Msg:TCMChanged);
begin
  FInfo := 0;
  Modified := true;
end;

procedure TULObjEditPanel.SetModified(OnOff: boolean);
begin
  if OnOff then begin
    FModified := true;
  end else begin
    FModified := false;
  end;
end;

function TULObjEditPanel.GetObj: TULObj;
begin
  if FObj = nil then begin
    Obj := CurULObj;
    CurULObj := nil;
  end;
  Result := FObj;
end;


{v0.64}
procedure Register;
begin
  RegisterComponents('Chromulan', [TULObjEditPanel]);
end;
{/v0.64}

end.
