unit ULObjUsrTreeFrm;{v0.47}{Form for rendering ULObj in TreeView }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://chromulan.org
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,

  ULObjUsru, {V0.62} ULObjUsrNodeu, ULObjUsrTreeViewu, ULObjEditPanelu,{/v0.62}
  ComCtrls, ULStringGrid, ExtCtrls;

{ override nodeusr to forward messages from ULObj to TreeView (owner) ulobju}
type
  TULObjUsrTreeForm = class(TForm)
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FTreeView: TULObjUsrTreeView;
    FULObjUsr: TULObjUsr;
    FOwnsObjUsr: boolean;
    procedure SetULObjUsr(AULObjUsr: TULObjUsr);
  public
    { Public declarations }
    property ULObjUsr: TULObjUsr read FULObjUsr write SetULObjUsr;
    property OwnsObjUsr: boolean read FOwnsObjUsr write FOwnsObjUsr;
  end;

var
  ULObjUsrTreeForm: TULObjUsrTreeForm;


implementation

{$R *.DFM}

procedure TULObjUsrTreeForm.SetULObjUsr(AULObjUsr: TULObjUsr);
begin
  if FULObjUsr = AULObjUsr then
    exit;
  if FULObjUsr <> nil then begin
    if FOwnsObjUsr then
      FULObjUsr.Free;
  end;
  FULObjUsr := AULObjUsr;
  FTreeView.Items.Clear;
  if FULObjUsr <> nil then begin
    FTreeView.NodeAdd(nil, AULObjUsr);
  end;
end;

procedure TULObjUsrTreeForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TULObjUsrTreeForm.FormCreate(Sender: TObject);
var
  g: TULStringGrid;
  s: TSplitter;
  p: TULObjEditPanel;
begin
  FTreeView := TULObjUsrTreeView.Create(Self);
  FTreeView.Width := 200;
  FTreeView.Height := 400;
  FTreeView.Align := alLeft;
  FTreeView.Parent := Self;

  s := TSplitter.Create(Self);
  s.Left := 200;
  s.Align := alLEft;
  s.Parent := Self;

  p := TULObjEditPanel.Create(Self);
  p.Left := 210;
  p.Width := 200;
  p.Align := alLeft;
  p.Parent := Self;
  FTreeView.Panel := p;

  s := TSplitter.Create(Self);
  s.Left := 400;
  s.Align := alLeft;
  s.Parent := Self;

  g := TULStringGrid.Create(Self);
  g.AutoSizeBrowseCols := true;
  g.Align := alClient;
  g.Left := 350;
  g.Top := 5;
  g.Width := 200;
  g.Height := 400;
  g.Parent := Self;

  FTreeView.Grid := g;
end;

procedure TULObjUsrTreeForm.FormDestroy(Sender: TObject);
begin
  ULObjUsr := nil;
end;

end.
