unit ULObj2XMLu;{v0.78}
{ Export/Import of ULObj objects to/from XML }

interface
uses
  SysUtils, Classes, ULObju;

{ Converts Obj to xml. Obj will be xml root element,
  its childs will become xml child elements (recursively).
  Indent can be used to add spaces to the start of the lines.
  (useful if called recursively, add some spaces if calling
  for a child).}
function ULObj2XML(Obj: TULObj; Indent: string): string;

{ Save Obj to XML file named AFileName. }
procedure ULObj2XMLFile(Obj: TULObj; const AFileName: string);

{ Converts xml to ULObj. Accepts only xml created by
  the ULObj2XML function or compatible one. }
function XML2ULObj(const AXML: string): TULObj;

implementation
uses
  ULObjDes;

function ULObj2XML(Obj: TULObj; Indent: string): string;
var i: integer;
begin
  { element's start tag }
  Result := Indent + '<' + Obj.RecIDStrStripped;
  { element's attributes }
  for i := 0 to Obj.FieldCount - 1 do begin
    if i = 0 then
      Result := Result + ' ';
    Result := Result +
      Obj.Fields[i].FldDesc.Name + '="' +
      Obj.Fields[i].AsString + '"';
    if i < Obj.FieldCount - 1 then
      Result := Result + ' ';
  end;
  Result := Result + '>' + sLineBreak;
  { child elements }
  for i := 0 to Obj.ChildCount - 1 do begin
    Result := Result + ULObj2XML(Obj.Childs[i], Indent + '  ');
  end;
  { element's end tag }
  Result := Result + Indent + '</' + Obj.RecIDStrStripped + '>' + sLineBreak;
end;

procedure ULObj2XMLFile(Obj: TULObj; const AFileName: string);
var
  s: string;
  f: TFileStream;
  fn: string;
begin
  fn := AFileName;
  if fn = '' then begin
    fn := Obj.FileName;
    if fn <> '' then
      fn := ChangeFileExt(Obj.FileName, '.xml');
  end;
  f := TFileStream.Create(fn, fmCreate);
  try
    s := ULObj2XML(Obj, '');
    f.WriteBuffer(PChar(s)^, length(s));
  finally
    f.Free;
  end;//tfilestream
end;

function XML2ULObj(const AXML: string): TULObj;
begin
  Result := nil;
end;


end.
