unit ComMonitorMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  UlanType, Deviceu;

type
  TCommMonitorMain = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FDevice: PExtDevDrv;
  public
    { Public declarations }
    procedure OnRxChar(Buffer: PByteArray; Count: integer);
  end;

var
  CommMonitorMain: TCommMonitorMain;

implementation

uses CommFrm;

{$R *.dfm}

procedure TCommMonitorMain.Button1Click(Sender: TObject);
begin
  CommForm.Show;
  CommForm.OnRxChar := OnRxChar;
  ExtDevInit(FDevice,  'ivan');
  ExtDevStart(FDevice);
end;

procedure TCommMonitorMain.OnRxChar(Buffer: PByteArray; Count: integer);
begin
  if FDevice <> nil then begin
    for i := 0 to Count - 1 do begin
      ExtDevDoCharIn(FDevice, Buffer^[i]);
    end;
  end;
end;

procedure TCommMonitorMain.FormDestroy(Sender: TObject);
begin
  ExtDevDone(FDevice);
end;

end.
