unit DevMonitorMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  UlanType, ExtCtrls,
  InfoFrm,
  ExtDevIntu // Deviceu

  ;

type
  TDevMonitorForm = class(TForm)
    ExtDevInitBtn: TButton;
    ExtDevStartBtn: TButton;
    ExtDevStopBtn: TButton;
    Timer1: TTimer;
    LogMemo: TMemo;
    TestBtn: TButton;
    TestEdit: TEdit;
    procedure FormDestroy(Sender: TObject);
    procedure ExtDevInitBtnClick(Sender: TObject);
    procedure ExtDevStartBtnClick(Sender: TObject);
    procedure ExtDevStopBtnClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure TestBtnClick(Sender: TObject);
  private
    { Private declarations }
    FDevice: TExtDev; //PExtDevDrv;
    FLastResult: integer;
    procedure Init;
    procedure Start;
    procedure Stop;
    procedure Done;
    procedure Log(const Msg: string);
    procedure SetResult(res: integer; const msg: string);
  public
    { Public declarations }
    procedure OnRxChar(Buffer: PByteArray; Count: integer);
  end;

var
  DevMonitorForm: TDevMonitorForm;

implementation

uses CommFrm;

{$R *.dfm}

procedure TDevMonitorForm.Init;
var s: shortstring;
begin
  FDevice := TExtDev.Create('device.ivan');
  if FDevice.Init = 0 then begin
    SetResult(FDevice.GetStr(epComMode, s), 'commode');
  //if ExtDevInit(FDevice,  'ivan') = 0 then begin
  //  ExtDevGetStr(FDevice, epComMode, s);
    CommForm.CommPort.ComMode := s;
    CommForm.OnRxChar := OnRxChar;

    ExtDevInitBtn.Enabled := false;

    ExtDevStartBtn.Enabled := true;
    TestBtn.Enabled := true;
    TestEdit.Enabled := true;
  end;
end;

procedure TDevMonitorForm.Start;
begin
  if FDevice = nil then begin
    ShowMessage('Init device first.');
    exit;
  end;
  SetResult(FDevice.Start{ExtDevStart(FDevice)}, 'start');
  CommForm.Show;

  ExtDevStopBtn.Enabled := true;
end;

procedure TDevMonitorForm.Stop;
begin
  if FDevice <> nil then
    FDevice.Stop;//ExtDevStop(FDevice);
end;

procedure TDevMonitorForm.Done;
begin
  if FDevice <> nil then begin
    //ExtDevStop(FDevice);// just to be sure
    //ExtDevDone(FDevice);
    FDevice.Free;
  end;
  MsgFormHide(longint(Self));
end;

procedure TDevMonitorForm.OnRxChar(Buffer: PByteArray; Count: integer);
var i: integer;
begin
  if FDevice <> nil then begin
    for i := 0 to Count - 1 do begin
      FDevice.DoCharIn(chr(Buffer^[i]));//(FDevice, chr(Buffer^[i]));
    end;
  end;
end;

procedure TDevMonitorForm.FormDestroy(Sender: TObject);
begin
  Done;
end;

procedure TDevMonitorForm.ExtDevInitBtnClick(Sender: TObject);
begin
  Init;
end;

procedure TDevMonitorForm.ExtDevStartBtnClick(Sender: TObject);
begin
  Start;
end;

procedure TDevMonitorForm.ExtDevStopBtnClick(Sender: TObject);
begin
  Stop;
end;

procedure TDevMonitorForm.Log(const Msg: string);
begin
  LogMemo.Lines.Add(Msg);
end;

procedure TDevMonitorForm.Timer1Timer(Sender: TObject);
var p: TExpPoint;
begin
  if FDevice <> nil then begin
    while FDevice.ReadPoint(p) = 0 {ExtDevReadPoint(FDevice, p) = 0} do begin
      Log(FloatToStr(p.X) + ', ' + FloatToStr(p.Y));
    end;
  end;
end;

procedure TDevMonitorForm.TestBtnClick(Sender: TObject);
var
  s: string;
  i: integer;
begin
  if FDevice <> nil then begin
    s := TestEdit.Text + #13;
    for i := 1 to length(s) do begin
      SetResult(FDevice.DoCharIn(s[i]), s);//(FDevice, s[i]), s);
    end;
  end;
end;

procedure TDevMonitorForm.SetResult(res: integer; const msg: string);
begin
  if res <> 0 then begin
    if FLastResult <> res then begin
      MsgFormShow('TDevMonitorForm ' + IntToStr(res) + ' ' + msg, longint(Self));
    end;
    FLastResult := res;
  end;
end;

end.
