unit XTreeFrm;{v0.47}{Form for rendering XML document in TreeView }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://chromulan.org
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}
interface

uses
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QComCtrls, QExtCtrls,
  xmlu, XTreeViewu, QStdCtrls;


type
  TXTreeForm = class(TForm)
    Panel1: TPanel;
    Splitter1: TSplitter;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    FTreeView: TXTreeView;

    function GetXMLNode: TXMLNode;
    procedure SetXMLNode(AXMLNode: TXMLNode);
    function GetFileName: TFileName;
    procedure SetFileName(const AFileName: TFileName);
  public
    { Public declarations }
    procedure Save;
    property XMLNode: TXMLNode read GetXMLNode write SetXMLNode;
    property FileName: TFileName read GetFileName write SetFileName;
    //property OwnsXMLNode: boolean read FOwnsXMLNode write FOwnsXMLNode;
  end;

var
  XTreeForm: TXTreeForm;


implementation

{$R *.XFM}

function TXTreeForm.GetXMLNode: TXMLNode;
begin
  Result := FTreeView.XMLNode;
end;

procedure TXTreeForm.SetXMLNode(AXMLNode: TXMLNode);
begin
  FTreeView.XMLNode := AXMLNode;
end;

function TXTreeForm.GetFileName: TFileName;
begin
  Result := FTreeView.FileName;
end;

procedure TXTreeForm.SetFileName(const AFileName: TFileName);
begin
  FTreeView.FileName := AFileName;
  Caption := AFileName;
end;

procedure TXTreeForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TXTreeForm.FormCreate(Sender: TObject);
//var
//  g: TULStringGrid;
//  s: TSplitter;
//  p: TULObjEditPanel;
begin
  FTreeView := TXTreeView.Create(Self);
  FTreeView.Width := 200;
  FTreeView.Height := 400;
  FTreeView.Align := alClient;//alLeft;
  FTreeView.Parent := Self;
  FTreeView.EditPanel := Panel1;
{
  s := TSplitter.Create(Self);
  s.Left := 200;
  s.Align := alLEft;
  s.Parent := Self;

  p := TULObjEditPanel.Create(Self);
  p.Left := 210;
  p.Width := 200;
  p.Align := alLeft;
  p.Parent := Self;
  FTreeView.Panel := p;

  s := TSplitter.Create(Self);
  s.Left := 400;
  s.Align := alLeft;
  s.Parent := Self;

  g := TULStringGrid.Create(Self);
  g.AutoSizeBrowseCols := true;
  g.Align := alClient;
  g.Left := 350;
  g.Top := 5;
  g.Width := 200;
  g.Height := 400;
  g.Parent := Self;

  FTreeView.Grid := g;
}
end;

procedure TXTreeForm.FormDestroy(Sender: TObject);
begin
//  XMLNode := nil;
end;

procedure TXTreeForm.Save;
begin
  FTreeView.Save;
end;

procedure TXTreeForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if FTreeView.Modified then begin
    case Application.MessageBox('File modified, save changes?', '', [smbYes, smbNo, smbCancel]) of
      smbYes: FTreeView.Save;
      smbCancel: CanClose := false;
    end;
  end;
end;

end.
