unit XTreeFrm2;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls,
  XTreeView2, xdom_2_3, QComCtrls;

type
  TXTreeForm = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    FTreeView: TXTreeView;

    function GetDomNode: TDomNode;
    procedure SetDomNode(ADomNode: TDomNode);
    function GetFileName: TFileName;
    procedure SetFileName(const AFileName: TFileName);
  public
    { Public declarations }
    property DomNode: TDomNode read GetDomNode write SetDomNode;
    property FileName: TFileName read GetFileName write SetFileName;
  end;

var
  XTreeForm: TXTreeForm;

implementation

{$R *.xfm}

function TXTreeForm.GetDomNode: TDomNode;
begin
  Result := FTreeView.DomNode;
end;

procedure TXTreeForm.SetDomNode(ADomNode: TDomNode);
begin
  FTreeView.DomNode := ADomNode;
end;

function TXTreeForm.GetFileName: TFileName;
begin
  Result := FTreeView.FileName;
end;

procedure TXTreeForm.SetFileName(const AFileName: TFileName);
begin
  FTreeView.FileName := AFileName;
  Caption := AFileName;
end;

procedure TXTreeForm.FormCreate(Sender: TObject);
begin
  FTreeView := TXTreeView.Create(Self);
  FTreeView.Width := 200;
  FTreeView.Height := 400;
  FTreeView.Align := alClient;//alLeft;
  FTreeView.Parent := Self;
end;

procedure TXTreeForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

end.
