import sys, string

def makeXXarray(file, prefix):
    """Take pascal source file and find there section with constants
      
       between lines {prefixXXXX} and {/prefixXXXX} and make from 
       all prefixXXXX constants comma separated list and output it to stdout
    """
    lines = open(file).readlines()
    inpref = False
    res = []
    for l in lines:
        if inpref:
            if '{/' + prefix + 'XXXX' in l:
                break
            else:
                if prefix in l:
                    sec = string.split(l, '=')
                    if len(sec) > 1:                        
                        res.append(string.strip(sec[0]))

    
        else:
            if '{' + prefix + 'XXXX' in l:
                inpref = True

    return string.join(res, ', ')

if __name__ == '__main__':
    if len(sys.argv) < 3:
        print makeXXarray.__doc__
    else:
        print makeXXarray(sys.argv[1], sys.argv[2])
