unit imp_editor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, SynEditHighlighter, SynHighlighterPas, SynEdit, Menus, ExtCtrls,
  StdCtrls, FileCtrl, ComCtrls;

type
  Timportdlg = class(TForm)
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    pashighlighter: TSynPasSyn;
    ed: TSynEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Saveas1: TMenuItem;
    N4: TMenuItem;
    Exit1: TMenuItem;
    messages: TListBox;
    Splitter1: TSplitter;
    Panel1: TPanel;
    Label1: TLabel;
    Button1: TButton;
    voutputdir: TEdit;
    Convert1: TMenuItem;
    Convert2: TMenuItem;
    CheckBox1: TCheckBox;
    StatusBar1: TStatusBar;
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Convert2Click(Sender: TObject);
    procedure edStatusChange(Sender: TObject; Changes: TSynStatusChanges);
  private
    { Private declarations }
    FFile: string;
  public
    function SaveCheck: Boolean;
    procedure Writeln(const s : string);
    procedure Readln(var s : string;const Promote,Caption : string);
  end;

var
  importdlg: Timportdlg;

implementation
uses
  ParserU;

{$R *.dfm}

procedure Timportdlg.Exit1Click(Sender: TObject);
begin
  Close;
end;

function Timportdlg.SaveCheck: Boolean;
begin
  if ed.Modified then
  begin
    case MessageDlg('File has not been saved, save now?', mtConfirmation, mbYesNoCancel, 0) of
      idYes:
        begin
          Save1Click(nil);
          Result := FFile <> '';
        end;
      IDNO: Result := True;
      else
        Result := False;
    end;
  end else Result := True;
end;

procedure Timportdlg.Open1Click(Sender: TObject);
begin
  if SaveCheck then
  begin
    if OpenDialog1.Execute then
    begin
      ed.ClearAll;
      ed.Lines.LoadFromFile(OpenDialog1.FileName);
      ed.Modified := False;
      FFile := OpenDialog1.FileName;
    end;
  end;
end;

procedure Timportdlg.Save1Click(Sender: TObject);
begin
  if FFile <> '' then
  begin
    ed.Lines.SaveToFile(FFile);
    ed.Modified := False;
  end else
    SaveAs1Click(nil);
end;

procedure Timportdlg.Saveas1Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
  begin
    FFile := SaveDialog1.FileName;
    ed.Lines.SaveToFile(FFile);
    ed.Modified := False;
  end;
end;

procedure Timportdlg.Button1Click(Sender: TObject);
var
  Dir: string;
begin
  if SelectDirectory(Dir, [sdAllowCreate, sdPerformCreate, sdPrompt], 0) then
    voutputdir.Text := dir;
end;

procedure Timportdlg.Convert2Click(Sender: TObject);
var
  T: TUnitParser;
  r: TStringList;
begin
  messages.clear;
  t := TUnitParser.Create('conv.ini');
  try
    t.Writeln := Writeln;
    t.Readln := Readln;
    t.UseUnitAtDT := CheckBox1.Checked;
    try
      t.ParseUnit(ed.Text);
    except
      on E: Exception do
      begin
        Writeln('Exception:'+e.Message);
        exit;
      end;
    end;
    if voutputdir.Text <> '' then
    begin
      r := TStringList.Create;
      try
        r.Text := t.OutputRT;
        r.SaveToFile(IncludeTrailingPathDelimiter(voutputdir.Text)+'ifpiir_'+t.Unitname+'.pas');
        r.Text := t.OutputDT;
        r.SaveToFile(IncludeTrailingPathDelimiter(voutputdir.Text)+'ifpii_'+t.Unitname+'.pas');
      finally
        r.Free;
      end;
    end else
      Messages.Items.Add('Skipping output, please set output path');
    messages.Items.Add('Succesfully parsed');
  finally
    t.Free;
  end;
end;

procedure Timportdlg.Readln(var s: string; const Promote, Caption: string);
begin
  s := InputBox(Caption, Promote, s)
end;

procedure Timportdlg.Writeln(const s: string);
begin

  messages.Items.Text := messages.Items.Text + s;
end;

procedure Timportdlg.edStatusChange(Sender: TObject;
  Changes: TSynStatusChanges);
begin
  StatusBar1.Panels[0].Text := IntToStr(ed.CaretY)+':'+IntToStr(ed.CaretX)
end;

end.
