unit ApexType;
interface
const
  ApexPacketSize = 138;
  ApexZeroHeadSize = 4;
  ApexPacketValueCount = 32;

{positions of packet fields in the raw data packet:}
  ApexZeroHeadPos = 0;
  ApexIDHeadPos = 4;
  ApexValuesPos = 7;
  ApexFootPos = 135;

  ApexSourceIDPos = 4;
  ApexTargetIDPos = 5;
  ApexEventIDPos = 6;

const
  OverValue = $C49F615E;
  OffValue = $BF56395E;

const
{EventIDs}
  eiData = $4F;
  eiMark = $4E;{??}
{/EventIDs}

type

  TApexZeroHead = array[0..ApexZeroHeadSize - 1] of byte;
  PApexZeroHead = ^TApexZeroHead;

  TApexIDHead = record
    SourceID, DestID, EventID:byte;
  end;
  PApexIDHead = ^TApexIDHead;

  TApexValues = array[0..ApexPacketValueCount-1] of single;
  PApexValues = ^TApexValues;

  TApexFoot = record
    Y1,Y2,Y3:byte;
  end;
  PApexFoot = ^TApexFoot;

  TApexPacketRec = record
    ZeroHead:PApexZeroHead;
    IDHead:PApexIDHead;
    Values:PApexValues;
    Foot:PApexFoot;
  end;

  TApexY = single;

  TApexPacket = record
    case integer of
      0:( Data:array[0..ApexPacketSize{138} - 1] of byte;);
      1:(
          ZeroHead:array[0..ApexZeroHeadSize - 1] of byte;
          X1:byte;{=$02 destination address }
          X2:byte;{=$03 source address }
          EventID:byte;{=$4F }
          Values:array[0..ApexPacketValueCount{32}-1] of TApexY;
            {i.e. 128 of bytes}
          Y1:byte;{=$7C}
          Y2:byte;{=$34 ... checksum?}
          Y3:byte;{=$83}
      );
  end;
  { 00 00 00 00 02 03 4F XX XX ... (128x)
    ZZ ZZ ZZ }

  TApexPacketInfo = record
    Pkt:TApexPacket;
    ScanningValues:boolean;
      { false if receiving bytes from comport and using CurPos counter,
        true if using ulan driver and using CurValPos counter }
    EndTime:longint;{when arrived the whole packet (last byte of the packet)}
    {for receiving:}
    Time:longint;{time of the first byte, set from EndTime of last packet}
    CurPos:byte;
      { position where to put next byte arrived (used if scanning for bytes
        not for values) }
    {LastByteTime:longint;{when the last byte (at CurByte - 1 pos)
      of packet arrived, used if packet not filled in one interrupt call}
    CurValPos:byte;
      { position where to put next value arrived (used if scanning for values
        instead of bytes) }
  end;

const
  lpCollectingFlag = $80;

implementation
end.