unit ModuProc;{Made by MAKEPROC program}

interface
uses ModuType, ApexType;

function ModulesCreate(var AModules: TModules): TModuleResult;
function ModulesDestroy(var AModules: TModules): TModuleResult;
function ModulesDoTimer(AModules: TModules): TModuleResult;
function ModulesDoAction(AModules: TModules; AModulesAction: TModulesAction; AInfo: pointer; AInfoSize: integer): TModuleResult; 

function ModulesCount(AModules: TModules): integer;
function ModulesModule(AModules: TModules; Index: integer): TModule;
function ModulesHasModule(AModules: TModules; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue; var AModule: TModule): boolean;
function ModulesGetPropInt(AModules: TModules; AModPropName: TModPropName): TModPropIntValue;
function ModulesSetPropInt(AModules: TModules; AModPropName: TModPropName; AModPropIntValue: TModPropIntValue): TModuleResult;
function ModulesSetPropStr(AModule: TModules; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue): TModuleResult;
function ModulesGetPropStr(AModules: TModules; AModPropName: TModPropName): TModPropStrValue; 

function ModulesIntToInt(AModules: TModules; mcn: TModulesConversionName; AValue: integer): integer;
function ModulesIntToStr(AModules: TModules; mcn: TModulesConversionName; AValue: integer): shortstring;

function ModuleGetPropInt(AModule: TModule; AModPropName: TModPropName): TModPropIntValue;
function ModuleGetPropStr(AModule: TModule; AModPropName: TModPropName): TModPropStrValue;
function ModuleSetPropInt(AModule: TModule; AModPropName: TModPropName; AModPropIntValue: TModPropIntValue): TModuleResult;
function ModuleSetPropStr(AModule: TModule; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue): TModuleResult;
function ModuleSetHandler(AModule: TModule; mhn: TModuleHandlerName; AHandler: TMethod): TModuleResult;
function ModuleDoAction(AModule: TModule; mda: TModuleDoAction; AInfo: pointer; AInfoSize: integer): TModuleResult;

function ModuleHasProp(AModule: TModule; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue; var AModuleProp: TModuleProp): boolean;

function ModulePropSetUsrStr(AModuleProp: TModuleProp; AModPropStrValue: TModPropStrValue): TModuleResult;
function ModulePropSetUsrInt(AModuleProp: TModuleProp; AModPropIntValue: TModPropIntValue): TModuleResult;
function ModulePropAsUsrStr(AModuleProp: TModuleProp): TModPropStrValue;
function ModulePropAsUsrInt(AModuleProp: TModuleProp): TModPropIntValue;
function ModulePropSetPropInt(AModuleProp: TModuleProp; AModPropName: TModPropName; AModPropIntValue: TModPropIntValue): TModuleResult;
function ModulePropGetPropInt(AModuleProp: TModuleProp; AModPropName: TModPropName): TModPropIntValue;
function ModulePropGetPropStr(AModuleProp: TModuleProp; AModPropName: TModPropName): TModPropStrValue;

function ModulePropDoAction(AModuleProp: TModuleProp; mpa: TModulePropAction; AInfo: pointer; AInfoSize: integer): TModuleResult;


{ Getmem for SII, open driver, init packet fifo, accept Mark from
  address list specified in AdrList. }
function RcvInit(var SII: PScanInputInfo; AdrList: shortstring): boolean;
{ Sets property of SII^ }
function RcvSetProp(SII: PScanInputInfo; rp: TRcvProperty; APValue: pointer): boolean;
{ Called from timer to poll for incoming packets. }
function RcvRun(SII: PScanInputInfo): boolean;
{ Called to retrieve incoming packets from fifo, returns true if ai filled,
  should be called repeatedly until returns false. }
function RcvGetPktInfo(SII: PScanInputInfo; var ai: TApexPacketInfo): boolean;
{ Close, free all. }
function RcvDone(var SII: PScanInputInfo): boolean;
procedure RcvDisable;
procedure RcvEnable;


const
  Modules: TModules = nil;

const
  MODUDLLName: string[12] = MODUDLL;
implementation
uses DLLUtl;

const
  DLLHandle:THandle = 0;
procedure Load;
begin
  if DLLHandle = 0 then DLLLoad(MODUDLLName, true, DLLHandle);
end;

const
  FModulesCreate:function(var AModules: TModules): TModuleResult = nil;

function ModulesCreate(var AModules: TModules): TModuleResult;
begin
  if not Assigned(FModulesCreate) then begin
    Load;
    DLLAssignProc(@FModulesCreate, DLLHandle, 'ModulesCreate', true);
  end;
  ModulesCreate := FModulesCreate(AModules);
end;

const
  FModulesDestroy:function(var AModules: TModules): TModuleResult = nil;

function ModulesDestroy(var AModules: TModules): TModuleResult;
begin
  if not Assigned(FModulesDestroy) then begin
    Load;
    DLLAssignProc(@FModulesDestroy, DLLHandle, 'ModulesDestroy', true);
  end;
  ModulesDestroy := FModulesDestroy(AModules);
end;

const
  FModulesDoTimer:function(AModules: TModules): TModuleResult = nil;

function ModulesDoTimer(AModules: TModules): TModuleResult;
begin
  if not Assigned(FModulesDoTimer) then begin
    Load;
    DLLAssignProc(@FModulesDoTimer, DLLHandle, 'ModulesDoTimer', true);
  end;
  ModulesDoTimer := FModulesDoTimer(AModules);
end;

const
  FModulesDoAction:function(AModules: TModules; AModulesAction: TModulesAction; AInfo: pointer; AInfoSize: integer): TModuleResult = nil;

function ModulesDoAction(AModules: TModules; AModulesAction: TModulesAction; AInfo: pointer; AInfoSize: integer): TModuleResult;
begin
  if not Assigned(FModulesDoAction) then begin
    Load;
    DLLAssignProc(@FModulesDoAction, DLLHandle, 'ModulesDoAction', true);
  end;
  ModulesDoAction := FModulesDoAction(AModules, AModulesAction, AInfo, AInfoSize);
end;

const
  FModulesCount:function(AModules: TModules): integer = nil;

function ModulesCount(AModules: TModules): integer;
begin
  if not Assigned(FModulesCount) then begin
    Load;
    DLLAssignProc(@FModulesCount, DLLHandle, 'ModulesCount', true);
  end;
  ModulesCount := FModulesCount(AModules);
end;

const
  FModulesModule:function(AModules: TModules; Index: integer): TModule = nil;

function ModulesModule(AModules: TModules; Index: integer): TModule;
begin
  if not Assigned(FModulesModule) then begin
    Load;
    DLLAssignProc(@FModulesModule, DLLHandle, 'ModulesModule', true);
  end;
  ModulesModule := FModulesModule(AModules, Index);
end;

const
  FModulesHasModule:function(AModules: TModules; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue; var AModule: TModule): boolean = nil;

function ModulesHasModule(AModules: TModules; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue; var AModule: TModule): boolean;
begin
  if not Assigned(FModulesHasModule) then begin
    Load;
    DLLAssignProc(@FModulesHasModule, DLLHandle, 'ModulesHasModule', true);
  end;
  ModulesHasModule := FModulesHasModule(AModules, AModPropName, AModPropStrValue, AModule);
end;

const
  FModulesGetPropInt:function(AModules: TModules; AModPropName: TModPropName): TModPropIntValue = nil;

function ModulesGetPropInt(AModules: TModules; AModPropName: TModPropName): TModPropIntValue;
begin
  if not Assigned(FModulesGetPropInt) then begin
    Load;
    DLLAssignProc(@FModulesGetPropInt, DLLHandle, 'ModulesGetPropInt', true);
  end;
  ModulesGetPropInt := FModulesGetPropInt(AModules, AModPropName);
end;

const
  FModulesSetPropInt:function(AModules: TModules; AModPropName: TModPropName; AModPropIntValue: TModPropIntValue): TModuleResult = nil;

function ModulesSetPropInt(AModules: TModules; AModPropName: TModPropName; AModPropIntValue: TModPropIntValue): TModuleResult;
begin
  if not Assigned(FModulesSetPropInt) then begin
    Load;
    DLLAssignProc(@FModulesSetPropInt, DLLHandle, 'ModulesSetPropInt', true);
  end;
  ModulesSetPropInt := FModulesSetPropInt(AModules, AModPropName, AModPropIntValue);
end;

const
  FModulesSetPropStr:function(AModule: TModules; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue): TModuleResult = nil;

function ModulesSetPropStr(AModule: TModules; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue): TModuleResult;
begin
  if not Assigned(FModulesSetPropStr) then begin
    Load;
    DLLAssignProc(@FModulesSetPropStr, DLLHandle, 'ModulesSetPropStr', true);
  end;
  ModulesSetPropStr := FModulesSetPropStr(AModule, AModPropName, AModPropStrValue);
end;

const
  FModulesGetPropStr:function(AModules: TModules; AModPropName: TModPropName): TModPropStrValue = nil;

function ModulesGetPropStr(AModules: TModules; AModPropName: TModPropName): TModPropStrValue;
begin
  if not Assigned(FModulesGetPropStr) then begin
    Load;
    DLLAssignProc(@FModulesGetPropStr, DLLHandle, 'ModulesGetPropStr', true);
  end;
  ModulesGetPropStr := FModulesGetPropStr(AModules, AModPropName);
end;

const
  FModulesIntToInt:function(AModules: TModules; mcn: TModulesConversionName; AValue: integer): integer = nil;

function ModulesIntToInt(AModules: TModules; mcn: TModulesConversionName; AValue: integer): integer;
begin
  if not Assigned(FModulesIntToInt) then begin
    Load;
    DLLAssignProc(@FModulesIntToInt, DLLHandle, 'ModulesIntToInt', true);
  end;
  ModulesIntToInt := FModulesIntToInt(AModules, mcn, AValue);
end;

const
  FModulesIntToStr:function(AModules: TModules; mcn: TModulesConversionName; AValue: integer): shortstring = nil;

function ModulesIntToStr(AModules: TModules; mcn: TModulesConversionName; AValue: integer): shortstring;
begin
  if not Assigned(FModulesIntToStr) then begin
    Load;
    DLLAssignProc(@FModulesIntToStr, DLLHandle, 'ModulesIntToStr', true);
  end;
  ModulesIntToStr := FModulesIntToStr(AModules, mcn, AValue);
end;

const
  FModuleGetPropInt:function(AModule: TModule; AModPropName: TModPropName): TModPropIntValue = nil;

function ModuleGetPropInt(AModule: TModule; AModPropName: TModPropName): TModPropIntValue;
begin
  if not Assigned(FModuleGetPropInt) then begin
    Load;
    DLLAssignProc(@FModuleGetPropInt, DLLHandle, 'ModuleGetPropInt', true);
  end;
  ModuleGetPropInt := FModuleGetPropInt(AModule, AModPropName);
end;

const
  FModuleGetPropStr:function(AModule: TModule; AModPropName: TModPropName): TModPropStrValue = nil;

function ModuleGetPropStr(AModule: TModule; AModPropName: TModPropName): TModPropStrValue;
begin
  if not Assigned(FModuleGetPropStr) then begin
    Load;
    DLLAssignProc(@FModuleGetPropStr, DLLHandle, 'ModuleGetPropStr', true);
  end;
  ModuleGetPropStr := FModuleGetPropStr(AModule, AModPropName);
end;

const
  FModuleSetPropInt:function(AModule: TModule; AModPropName: TModPropName; AModPropIntValue: TModPropIntValue): TModuleResult = nil;

function ModuleSetPropInt(AModule: TModule; AModPropName: TModPropName; AModPropIntValue: TModPropIntValue): TModuleResult;
begin
  if not Assigned(FModuleSetPropInt) then begin
    Load;
    DLLAssignProc(@FModuleSetPropInt, DLLHandle, 'ModuleSetPropInt', true);
  end;
  ModuleSetPropInt := FModuleSetPropInt(AModule, AModPropName, AModPropIntValue);
end;

const
  FModuleSetPropStr:function(AModule: TModule; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue): TModuleResult = nil;

function ModuleSetPropStr(AModule: TModule; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue): TModuleResult;
begin
  if not Assigned(FModuleSetPropStr) then begin
    Load;
    DLLAssignProc(@FModuleSetPropStr, DLLHandle, 'ModuleSetPropStr', true);
  end;
  ModuleSetPropStr := FModuleSetPropStr(AModule, AModPropName, AModPropStrValue);
end;

const
  FModuleSetHandler:function(AModule: TModule; mhn: TModuleHandlerName; AHandler: TMethod): TModuleResult = nil;

function ModuleSetHandler(AModule: TModule; mhn: TModuleHandlerName; AHandler: TMethod): TModuleResult;
begin
  if not Assigned(FModuleSetHandler) then begin
    Load;
    DLLAssignProc(@FModuleSetHandler, DLLHandle, 'ModuleSetHandler', true);
  end;
  ModuleSetHandler := FModuleSetHandler(AModule, mhn, AHandler);
end;

const
  FModuleDoAction:function(AModule: TModule; mda: TModuleDoAction; AInfo: pointer; AInfoSize: integer): TModuleResult = nil;

function ModuleDoAction(AModule: TModule; mda: TModuleDoAction; AInfo: pointer; AInfoSize: integer): TModuleResult;
begin
  if not Assigned(FModuleDoAction) then begin
    Load;
    DLLAssignProc(@FModuleDoAction, DLLHandle, 'ModuleDoAction', true);
  end;
  ModuleDoAction := FModuleDoAction(AModule, mda, AInfo, AInfoSize);
end;

const
  FModuleHasProp:function(AModule: TModule; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue; var AModuleProp: TModuleProp): boolean = nil;

function ModuleHasProp(AModule: TModule; AModPropName: TModPropName; AModPropStrValue: TModPropStrValue; var AModuleProp: TModuleProp): boolean;
begin
  if not Assigned(FModuleHasProp) then begin
    Load;
    DLLAssignProc(@FModuleHasProp, DLLHandle, 'ModuleHasProp', true);
  end;
  ModuleHasProp := FModuleHasProp(AModule, AModPropName, AModPropStrValue, AModuleProp);
end;

const
  FModulePropSetUsrStr:function(AModuleProp: TModuleProp; AModPropStrValue: TModPropStrValue): TModuleResult = nil;

function ModulePropSetUsrStr(AModuleProp: TModuleProp; AModPropStrValue: TModPropStrValue): TModuleResult;
begin
  if not Assigned(FModulePropSetUsrStr) then begin
    Load;
    DLLAssignProc(@FModulePropSetUsrStr, DLLHandle, 'ModulePropSetUsrStr', true);
  end;
  ModulePropSetUsrStr := FModulePropSetUsrStr(AModuleProp, AModPropStrValue);
end;

const
  FModulePropSetUsrInt:function(AModuleProp: TModuleProp; AModPropIntValue: TModPropIntValue): TModuleResult = nil;

function ModulePropSetUsrInt(AModuleProp: TModuleProp; AModPropIntValue: TModPropIntValue): TModuleResult;
begin
  if not Assigned(FModulePropSetUsrInt) then begin
    Load;
    DLLAssignProc(@FModulePropSetUsrInt, DLLHandle, 'ModulePropSetUsrInt', true);
  end;
  ModulePropSetUsrInt := FModulePropSetUsrInt(AModuleProp, AModPropIntValue);
end;

const
  FModulePropAsUsrStr:function(AModuleProp: TModuleProp): TModPropStrValue = nil;

function ModulePropAsUsrStr(AModuleProp: TModuleProp): TModPropStrValue;
begin
  if not Assigned(FModulePropAsUsrStr) then begin
    Load;
    DLLAssignProc(@FModulePropAsUsrStr, DLLHandle, 'ModulePropAsUsrStr', true);
  end;
  ModulePropAsUsrStr := FModulePropAsUsrStr(AModuleProp);
end;

const
  FModulePropAsUsrInt:function(AModuleProp: TModuleProp): TModPropIntValue = nil;

function ModulePropAsUsrInt(AModuleProp: TModuleProp): TModPropIntValue;
begin
  if not Assigned(FModulePropAsUsrInt) then begin
    Load;
    DLLAssignProc(@FModulePropAsUsrInt, DLLHandle, 'ModulePropAsUsrInt', true);
  end;
  ModulePropAsUsrInt := FModulePropAsUsrInt(AModuleProp);
end;

const
  FModulePropSetPropInt:function(AModuleProp: TModuleProp; AModPropName: TModPropName; AModPropIntValue: TModPropIntValue): TModuleResult = nil;

function ModulePropSetPropInt(AModuleProp: TModuleProp; AModPropName: TModPropName; AModPropIntValue: TModPropIntValue): TModuleResult;
begin
  if not Assigned(FModulePropSetPropInt) then begin
    Load;
    DLLAssignProc(@FModulePropSetPropInt, DLLHandle, 'ModulePropSetPropInt', true);
  end;
  ModulePropSetPropInt := FModulePropSetPropInt(AModuleProp, AModPropName, AModPropIntValue);
end;

const
  FModulePropGetPropInt:function(AModuleProp: TModuleProp; AModPropName: TModPropName): TModPropIntValue = nil;

function ModulePropGetPropInt(AModuleProp: TModuleProp; AModPropName: TModPropName): TModPropIntValue;
begin
  if not Assigned(FModulePropGetPropInt) then begin
    Load;
    DLLAssignProc(@FModulePropGetPropInt, DLLHandle, 'ModulePropGetPropInt', true);
  end;
  ModulePropGetPropInt := FModulePropGetPropInt(AModuleProp, AModPropName);
end;

const
  FModulePropGetPropStr:function(AModuleProp: TModuleProp; AModPropName: TModPropName): TModPropStrValue = nil;

function ModulePropGetPropStr(AModuleProp: TModuleProp; AModPropName: TModPropName): TModPropStrValue;
begin
  if not Assigned(FModulePropGetPropStr) then begin
    Load;
    DLLAssignProc(@FModulePropGetPropStr, DLLHandle, 'ModulePropGetPropStr', true);
  end;
  ModulePropGetPropStr := FModulePropGetPropStr(AModuleProp, AModPropName);
end;

const
  FModulePropDoAction:function(AModuleProp: TModuleProp; mpa: TModulePropAction; AInfo: pointer; AInfoSize: integer): TModuleResult = nil;

function ModulePropDoAction(AModuleProp: TModuleProp; mpa: TModulePropAction; AInfo: pointer; AInfoSize: integer): TModuleResult;
begin
  if not Assigned(FModulePropDoAction) then begin
    Load;
    DLLAssignProc(@FModulePropDoAction, DLLHandle, 'ModulePropDoAction', true);
  end;
  ModulePropDoAction := FModulePropDoAction(AModuleProp, mpa, AInfo, AInfoSize);
end;

const
  FRcvInit:function(var SII: PScanInputInfo; AdrList: shortstring): boolean = nil;

function RcvInit(var SII: PScanInputInfo; AdrList: shortstring): boolean;
begin
  if not Assigned(FRcvInit) then begin
    Load;
    DLLAssignProc(@FRcvInit, DLLHandle, 'RcvInit', true);
  end;
  RcvInit := FRcvInit(SII, AdrList);
end;

const
  FRcvSetProp:function(SII: PScanInputInfo; rp: TRcvProperty; APValue: pointer): boolean = nil;

function RcvSetProp(SII: PScanInputInfo; rp: TRcvProperty; APValue: pointer): boolean;
begin
  if not Assigned(FRcvSetProp) then begin
    Load;
    DLLAssignProc(@FRcvSetProp, DLLHandle, 'RcvSetProp', true);
  end;
  RcvSetProp := FRcvSetProp(SII, rp, APValue);
end;

const
  FRcvRun:function(SII: PScanInputInfo): boolean = nil;

function RcvRun(SII: PScanInputInfo): boolean;
begin
  if not Assigned(FRcvRun) then begin
    Load;
    DLLAssignProc(@FRcvRun, DLLHandle, 'RcvRun', true);
  end;
  RcvRun := FRcvRun(SII);
end;

const
  FRcvGetPktInfo:function(SII: PScanInputInfo; var ai: TApexPacketInfo): boolean = nil;

function RcvGetPktInfo(SII: PScanInputInfo; var ai: TApexPacketInfo): boolean;
begin
  if not Assigned(FRcvGetPktInfo) then begin
    Load;
    DLLAssignProc(@FRcvGetPktInfo, DLLHandle, 'RcvGetPktInfo', true);
  end;
  RcvGetPktInfo := FRcvGetPktInfo(SII, ai);
end;

const
  FRcvDone:function(var SII: PScanInputInfo): boolean = nil;

function RcvDone(var SII: PScanInputInfo): boolean;
begin
  if not Assigned(FRcvDone) then begin
    Load;
    DLLAssignProc(@FRcvDone, DLLHandle, 'RcvDone', true);
  end;
  RcvDone := FRcvDone(SII);
end;

const
  FRcvDisable:procedure = nil;

procedure RcvDisable;
begin
  if not Assigned(FRcvDisable) then begin
    Load;
    DLLAssignProc(@FRcvDisable, DLLHandle, 'RcvDisable', true);
  end;
  FRcvDisable;
end;

const
  FRcvEnable:procedure = nil;

procedure RcvEnable;
begin
  if not Assigned(FRcvEnable) then begin
    Load;
    DLLAssignProc(@FRcvEnable, DLLHandle, 'RcvEnable', true);
  end;
  FRcvEnable;
end;

procedure Done;
begin
  if DLLHandle <> 0 then
    DLLFree(DLLHandle);
  DLLHandle := 0;
end;

const
  OldExitProc:pointer = nil;
{$S-}
procedure Ex;far;
begin
  ExitProc := OldExitProc;
  Done;
end;

begin
  OldExitProc := ExitProc;
  ExitProc := @Ex;
end.
(*
exports
  ModulesCreate,
  ModulesDestroy,
  ModulesDoTimer,
  ModulesDoAction,
  ModulesCount,
  ModulesModule,
  ModulesHasModule,
  ModulesGetPropInt,
  ModulesSetPropInt,
  ModulesSetPropStr,
  ModulesGetPropStr,
  ModulesIntToInt,
  ModulesIntToStr,
  ModuleGetPropInt,
  ModuleGetPropStr,
  ModuleSetPropInt,
  ModuleSetPropStr,
  ModuleSetHandler,
  ModuleDoAction,
  ModuleHasProp,
  ModulePropSetUsrStr,
  ModulePropSetUsrInt,
  ModulePropAsUsrStr,
  ModulePropAsUsrInt,
  ModulePropSetPropInt,
  ModulePropGetPropInt,
  ModulePropGetPropStr,
  ModulePropDoAction,
  RcvInit,
  RcvSetProp,
  RcvRun,
  RcvGetPktInfo,
  RcvDone,
  RcvDisable,
  RcvEnable,
*)
