unit ModuType;
{$I define.pas}
interface
{$IFDEF USEDLL}
uses
  ApexType, ListType;
{$ELSE}
uses
  Classes, Forms;
{$ENDIF}//apextype

type
  TCharBuffer= array[0..64000] of char;
  PCharBuffer = ^TCharBuffer;
  TByteBuffer = array[0..64000] of byte;
  PByteBuffer = ^TByteBuffer;
  TLongintBuffer = array[0..16000] of longint;
  PLongintBuffer = ^TLongintBuffer;

  TModules =  pointer;
  TModule = pointer;
  TModuleProp = pointer;
  TULDriver = pointer;
  TPortName = shortstring;


const
  MODUDLL = 'MODULES';
  NoWinPtr = nil;
  MaxModulePropCount = 100;
  ModulePropUpdateInterval = 1000;
    { readable values should be updated from device after every
      ModulePropUpdateInterval ms (if pfUpdateFromDeviceInTimer set) }
  {v0.13}
  MinModulePropUpdateInterval = 200;
    { update intervals can be only numbers dividable by this number }
  {/v0.13}

type
  TModulePropID = word;
    { Unique ID of the property in given device }
  TModulePropIDStr = string[6];
    { Ascii form of TModulePropID used in ULDPType/ULDPObju for searching the property
      (RecName) }
  TModulePropTypeDesc = shortstring;
  TModulePropDesc = shortstring;
  TModuleAddr = longint;
  { Ascii form of TModuleAddr used in ULDRType/ULDRObj, RecName }
  TModuleAddrStr = string[6];
{v0.64}             {scktcomp}
  { ModulePath = IPAddr/PortName/LoopAddr }
  { unique name of the module in the modules network }
  TModulePath = shortstring;

    { IP addr or hostname of the computer to which the module is connected,
      if 0 is specified local computer is assumed (127.0.0.1) }
    TModuleIPAddr = shortstring;

    { Name of the port on the computer to which the module is connected.
      e.g. UL_DRV for uLan driver, COMx for serial port, ...
      Eventual TCP/IP communicating devices can have port name in format
      'Protocol[:ProtocolPort]' e.g. 'UDP[:PortNr]'}
    TModulePortName = shortstring;

    { Address of the module in the loop(network) connected
      to the given port. Must be given (non zero) for UL_DRV port, for other
      ports can specified just 0, if only one device can be connected there. }
    TModuleLoopAddrStr = TModuleAddrStr;
{/v0.64}

type
  TModulePropFlags = longint;{see pfXXXX}

{pfXXXX module property flags, permanent properties of the module property }
const
  pfWrite = 1;
    { Property can be written to device }
  pfRead = 2;
    { Property can be read from device }
  pfUpdateToDeviceInTimer = 4;
    { Send "write value to device request" to device during next DoTimer if
      change of value in PC detected, if not set then the request is sent
      immediately after the value of property was changed from PC (= default). }
  pfUpdateFromDeviceInTimer = 8;
    { Value of the property is requested from device during every DoTimer call.
      If the flag is not set (=default), than the value is requested from
      the device only if the state flag of the property psReadRequested is set
      (automatically only after program start) }
  {v0.25}
  {pfNeedUpdateFromDevice = $10;}
  {/v0.25}
  {v0.74}
  { Override global PropertyLogging flag. }
  pfForceLog = $20;
  { Override global PropertyLogging flag. }
  pfForceNoLog = $40;
  {/0.74}
{/pfXXXX}
{v0.74}
type
  { Parameters for TModuleProp.SetLogState }
  TPropLogState = (
    plsDefault,
    plsNo,
    plsYes
  );
{/v0.74}
type
  TModulePropState = longint;
    { Runtime state flags of the property }
{psXXXX}
const
  psDetected = 1;
    { The property was autodetected in the device (as valid=present),
      i.e. it's value can be safely read/written from/to the device,
      (not controlled normally - autodetection takes place only if
      change in device description detected.). }
  {psWriteRequested = 2;
    { Set on (together with psModifiedFromPC) when value of the property was
      changed in PC and the property flag pfUpdateToDeviceInTimer is set.
      I.e. request for update will be sent in next DoTimer call.
      not used, modified is enough }
  psWriteSubmitted = 4;
    { Set by communication module if message to device containing request
      for setting device's property value was sent. This request is made
      either from timer or if pfUpdateToDeviceInTimer is not set, then
      from SetPropVal calls. }
  psReadRequested = 8;
    { Set on by user if wants the property copy its value from device during
      next DoTimer call. }
  psReadSubmitted = $10;
    { Set by communication module if message to device containing request
      for getting device's property value was sent }
  psModifiedFromPC = $20;
    { Current value of the property was set from PC (i.e. it is not sure
      that the same value is in device). Write value request to device
      might have been sent if  pfUpdateToDeviceInTimer is not set, otherwise
      it will be sent during the next DoTimer call }
  psUpdatedFromDevice = $40;
    { Current value of the property was set from device (from received ulan
      message) and was not modified from PC since that time) }
{/psXXXX}


{ptXXXX TModulePropTypeID constants}
type
  TModulePropTypeID = (
    ptCommand,{no data}
    ptWord,   {2 bytes data}
    ptInt32, {4 bytes data}
    ptSingle,  {4 bytes data}
    ptInt16
    {v0.50}
    ,ptUnknown
    {/v0.50}
  );
{/ptXXXX}

{piXXXX ModulePropertyIDs uldptype.PropIDStr}
const
  piFlow = 220;{u2/.3;rw}

  piPCFG = 224;{u2}
  piPress = 225;{u2/.1;r}
  piPress_H = 226;{u2/.1;rw}
  piPress_L = 227;{u2/.1;rw}

  piStop = 250;{e}
  piStart = 251;{e}
  piPurge = 252;{e}

  piGrad_B = 231;{u2/*256}
  piGrad_C = 232;{u2/*256}

  piGradDir = 239;{u2}

  { ID of properties if TModule object (not ModuleProp objects) are negative }
  piULDR = -1;
    { access ULDR object of the module }
  piDeviceName = -2;
{/piXXXX}
const
  MaxModulePropID = 1000;

type
  TModuleResult = integer;
{mrXXXX}
const
  morOK = 0; {mrOK is Modulresult}
  mr0 = 9900;
  mrInvalidOIState = mr0 + 1;
  mrInvalidPropDesc = mr0 + 2;
  mrInvalidTypeDesc = mr0 + 3;
  mrPropIsReadOnly = mr0 + 4;
  mrPropIsWriteOnly = mr0 + 5;

  mrNotInUlanMode = mr0 + 6;
  mrUlanDriverInitFailed = mr0 + 7;
  mrCanNotFreeULDrv = mr0 + 8;

  mrInvalidProp = mr0 + 9;
  mrInvalidModulePropAction = mr0 + 10;
  mrInvalidHandlerName = mr0 + 11;
  mrInvalidModulesAction = mr0 + 12;
  mrInvalidModulesProp = mr0 + 13;
  mrInvalidModuleAction = mr0 + 14;
{/mrXXXX}

type
  TModulesConversionName = shortstring;
const
  mcnASStatus2Str = 'ASStatus2Str';
  mcnASStatusDecode = 'ASStatusDecode';
  mcnASState2Str = 'ASState2Str';
  mcnDevStat2Int = 'DevStatToInt';
  mcnDevState2Str = 'DevState2Str';

type
  TModuleHandlerName = shortstring;
const
  mhnOnMark = 'OnMark';

type
  { Specifies what the TModule object should do as soon as possible, these action
    IDs stacked to TModule.FActionList, executed in timers. }
  TModuleActionID = integer;
{maXXXX}
const
  ma0 = 11000;
  maGetRWPropIDList = ma0 + 1;
    { Send message requesting list of input propety IDs. No info. }
  maGetROPropIDList = ma0 + 2;
    { Send message requesting list of readonly propety IDs. No info. }
  maGetRWPropIDDesc = ma0 + 3;
    { Send message requesting description of the r/w property. Info = PropID. }
  maGetROPropIDDesc = ma0 + 4;
    { Send message requesting description of the read only property.
      Info = PropID. }
  maGetPropVal = ma0 + 5;
    { Send message requesting value of property. Info = ModuleProp. }
  maSetPropVal = ma0 + 6;
    { Send message requesting upload of new value to device. Info = ModuleProp. }
  maGetPropVals = ma0 + 7;
    { Send message requesting values of all readable properties from device.
      No info. }
  maSetPropVals = ma0 + 8;
    { Send message that will upload values of all writable properties to device.
      No info. }
{/maXXXX}

type
  TModuleDoAction = integer;
{mdaXXXX parameters to ModuleDoAction function}
const
  mda0 = 15000;
  mdaDoCommand = mda0 + 1;
  mdaUserRegister = mda0 + 2;
  mdaUserUnregister = mda0 + 3;
  mdaStreamMessageCreate = mda0 + 4;
  mdaStreamMessageWrite = mda0 + 5;
  mdaStreamMessageClose = mda0 + 6;
{/mdaXXXX}

type
  TModulesAction = integer;
{msaXXXX Modules actions; parameters to ModulesDoAction }
const
  msa0 = 1300;
  msaULDrvLock = msa0 + 1;
  msaULDrvFree = msa0 + 2;
  msaULDrvUnlock = msa0 + 3;
  msaScanForModules = msa0 + 4;
  msaBrowse = msa0 + 5;
  msaDynAddrServerRequest = msa0 + 6;
  msaULDrvSetupExecute = msa0 + 7;
  { Return 0 if DeviceModeCheck returns true. }
  msaDeviceModeCheck = msa0 + 8;
{/msaXXXX}

type
  TModulePropAction = integer;
{mpaXXXX ModuleProp actions; parameters to ModulePropDoAction function}
const
   mpa0 = 12000;
   mpaRequestRead = mpa0 + 1; //
{/mpaXXXX}
{dsXXXX}
type
  TModuleDetectState = (
    dsUnknown,  { state after starting the program until some communication takes place }
    dsDetecting, { request sent to device }
    dsNotPresent, { no answer came from device for AliveTimeout  }
    dsPresent {v0.24}, { device answered ok }
    dsSuspended{/v0.24} { user set the module state to this value manually,
      only in this state no attempt for connection are made by the program }
  );
{/dsXXXX}
{v0.24}
const
  DefaultAliveTimeout = 5; { in seconds, after what time without answer is
    module considered to be lost - disconnected }
  pvValueInPC = 'ValueInPC';
{/v0.24}

{$IFDEF USEDLL}
{From ModuUtl}

{AutoSampler}
type
  TASState = integer;
  { AutoSampler state }

{assXXXX}
const

  astOK = 0;
  astPrepared = 1;
  astOperating = 2;

  astError = 3;

  astCalibrationError = 3;
  astSensorAError = 4;
  astSensorBError = 5;
  astSequencerError = 6;
  astArmMotorError = 7;
  astPeristalticMotorError = 8;
  astDCMotorError = 9;
  astDiskPositionError = 10;
  astBubbleError = 11;
  astUnidentifiedError = 12;
  astCommunicationError = 13;
  astUnknownState = 14;

  ASStateCount = 15;
{/assXXXX}
{/Autosampler}

{dstXXXX}
{ Device / Module state }
type
  TDevState = integer;
const
  dstOK = 0;
  dstOutOfLimits = 1;
  dstTooHigh = 2;
  dstTooLow = 3;
  dstUnstable = 4;
  dstDefectiveLamp = 5;
  dstTooDark = 6;
  dstCommunicationError = 7;
  dstUnknownState = 8;
  dstOff = 9;
  dstDeviceError = 10;
  DevStateCount = 11;
{/dstXXXX}

{/From ModuUtl}

{$ELSE} {/IFDEF USEDLL}
const
  fnDeviceName = 'DeviceName';
  fnDeviceMode = 'DeviceMode';
  fnExtDevDrvName = 'ExtDevDrvName';
{$ENDIF}

{mpXXXX Module(s) property codes used in ModuleGetPropXXXX functions }
const
  mpDeviceType = 'DeviceType'; // see TDeviceType
  mpDeviceMode = 'DeviceMode';
  mpDevicePortName = 'DevicePortName'; //uldrtype
  mpDeviceName = 'DeviceName';
  mpExtDevDrvName = 'ExtDevDrvName';
  mpAddrStr = 'AddrStr';

  mpULObjPath = 'ULObjPath';
  mpULD = 'ULD';
  mpRecID = 'RecID';
  mpULDR = 'ULDR';
  mpIDName = 'IDName';

  mpPropDesc = 'PropDesc';
  mpPropIDStr = 'PropIDStr';
  mpLogState = 'LogState';
  mpUpdateInterval = 'UpdateInterval';
  mpTypeDesc = 'TypeDesc';
  
  mpULDrv = 'ULDrv';
  mpULDrvLocked = 'ULDrvLocked';
  mpULDrvFailed = 'ULDrvFailed';
  mpAutodetecting = 'Autodetecting';
  mpExtDevs = 'ExtDevs';
  mpUVDetAddr = 'UVDetAddr';
  mpCurDeviceMode = 'CurDeviceMode';
  mpCurPortName = 'CurPortName';
  mpShouldAutoscanForModules = 'ShouldAutoscanForModules';
  mpUlanModeAllowedByOS = 'UlanModeAllowedByOS';
  mpApplication = 'Application'; 
{/mpXXXX}

type
  //TModPropID = integer;
  TModPropName = shortstring;
  TModPropStrValue = shortstring;
  TModPropIntValue = integer;


{$IFDEF USEDLL}
type
  TWinPtr = pointer;

  {moved from ul_lcabs.pas}
  PScanInputInfo = ^TScanInputInfo;
  TScanInputInfo = record
    {uloi:Puloi_coninfo;}
    Drv: pointer;//TULDriver;
      { handle to opened driver }
    fifo:TLst;
      {storage for incoming packets}
    pktinfo:TApexPacketInfo;
      { currently beeing created packet }
  end;
  {/}

{moved from ulantype.pas}
type
  TRcvProperty = integer;

{rpXXXX scaninputinfo receive obect properties (ul_lcabs),
  params for RcvSetProp, RcvGetProp }
const
  rpZeroTime = 1;
{/rpXXXX}
{/}

{$ELSE}
type
  TWinPtr = TForm;
{$ENDIF}


implementation

end.
