unit ApexType;
interface
const
  ApexPacketSize = 138;
  ApexZeroHeadSize = 4;
  ApexPacketValueCount = 32;

{positions of packet fields in the raw data packet:}
  ApexZeroHeadPos = 0;
  ApexIDHeadPos = 4;
  ApexValuesPos = 7;
  ApexFootPos = 135;

  ApexSourceIDPos = 4;
  ApexTargetIDPos = 5;
  ApexEventIDPos = 6;

const
  OverValue = $C49F615E;
  OffValue = $BF56395E;

const
{EventIDs}
  eiData = $4F;
  eiMark = $4E;{??}
{/EventIDs}

type
(*
  TPointCount = longint;
  TPeakCount = longint;

  TApexX = longint;
  TApexY = single;
  TAreaSize = real;
  PApexPoint = ^TApexPoint;
  TApexPoint = record
    X:TApexX;
    Y:TApexY;
  end;
  TApexXLimit = record
    Min,Max:TApexX;
    Size:TApexX;
  end;
  TApexYLimit = record
    Min, Max:TApexY;
    Size:TApexY;
  end;

  TScreenX = integer;
  TScreenY = integer;
  PScreenPoint = ^TScreenPoint;

  TScreenPoint = record
     X:TScreenX;
     Y:TScreenY;
  end;

  TScreenOpt = record {what part of screen used to draw the spectrum}
    Left:TScreenX;
    Top :TScreenY;
    Width:TScreenX;
    Height:TScreenY;
    ZeroIsOnTop:boolean;{true if y coordinate has zero on the top of the
     screen; the other values are in this values, i.e. the value
     of Top variable is mostly close to zero if ZeroIsOnTop=true,
     otherwise is close to Height}
  end;


  TUserX = real;
  TUserY = real;
  PUserPoint = ^TUserPoint;
  TUserPoint = record
    X:TUserX;
    Y:TUserY;
  end;

  TUserViewLimit = record
    Min:TUserPoint; {x..time in minutes entered by user, limits of spectrum view}
    Max:TUserPoint; {y..limits of spectrum view in AU units}
    Size:TUserPoint;{calculated from Min, Max}
  end;

  TApexViewLimit = record{limits of spectrum view in apexrecord units:}
    Min:TApexPoint;
    Max:TApexPoint;
    {x..limits in milisecond of spectrum view}
    {y..up and down limit of the spectrum in AU units}
    Size:TApexPoint;{calculated from Min,Max}
  end;
*)

  TApexZeroHead = array[0..ApexZeroHeadSize - 1] of byte;
  PApexZeroHead = ^TApexZeroHead;

  TApexIDHead = record
    SourceID, DestID, EventID:byte;
  end;
  PApexIDHead = ^TApexIDHead;

  TApexValues = array[0..ApexPacketValueCount-1] of single;
  PApexValues = ^TApexValues;

  TApexFoot = record
    Y1,Y2,Y3:byte;
  end;
  PApexFoot = ^TApexFoot;

  TApexPacketRec = record
    ZeroHead:PApexZeroHead;
    IDHead:PApexIDHead;
    Values:PApexValues;
    Foot:PApexFoot;
  end;

  TApexY = single;

  TApexPacket = record
    case integer of
      0:( Data:array[0..ApexPacketSize{138} - 1] of byte;);
      1:(
          ZeroHead:array[0..ApexZeroHeadSize - 1] of byte;
          X1:byte;{=$02 destination address }
          X2:byte;{=$03 source address }
          EventID:byte;{=$4F }
          Values:array[0..ApexPacketValueCount{32}-1] of TApexY;
            {i.e. 128 of bytes}
          Y1:byte;{=$7C}
          Y2:byte;{=$34 ... checksum?}
          Y3:byte;{=$83}
      );
  end;
  { 00 00 00 00 02 03 4F XX XX ... (128x)
    ZZ ZZ ZZ }

  TApexPacketInfo = record
    Pkt:TApexPacket;
    ScanningValues:boolean;
      { false if receiving bytes from comport and using CurPos counter,
        true if using ulan driver and using CurValPos counter }
    EndTime:longint;{when arrived the whole packet (last byte of the packet)}
    {for receiving:}
    Time:longint;{time of the first byte, set from EndTime of last packet}
    CurPos:byte;
      { position where to put next byte arrived (used if scanning for bytes
        not for values) }
    {LastByteTime:longint;{when the last byte (at CurByte - 1 pos)
      of packet arrived, used if packet not filled in one interrupt call}
    CurValPos:byte;
      { position where to put next value arrived (used if scanning for values
        instead of bytes) }
  end;

const
  lpCollectingFlag = $80;

(*
type
  {points containing also their Data^ index, used for working up of spectrum}
  TIndexPoint = record
    Point:TApexPoint;
    Index:TPointCount;
  end;

  TIndexLimit = record
    Min, Max:TIndexPoint;
  end;

  PSpectrumOpt = ^TSpectrumOpt;
  TSpectrumOpt = record
    MaxPointCount:TPointCount;{maximally that number of points will
       be taken to account 0 for all}
    MaxPeakCount:TPeakCount;{max this number of points will be stored,
       0 for all}
    Trashold:TApexY;{only peaks with y above that value will be stored}
    BaseLine:TApexY;

    {only peaks within specified values will be considered
     to be separate peeks, value 0 means no limits:}
    PeakHeight:TApexYLimit;
    PeakArea:TApexYLimit;
    PeakWidth:TApexXLimit;


    PeakStartLevel:TApexY;
    PeakEndLevel:TApexY; {for y > baseline + PeakStartLevel the peak starts}
                         {for y < baseline + PeakEndLevel the peak ends}
    ViewLimit:TApexViewLimit;   {what portion of the spectrum to show}
    Limit:TApexViewLimit;{min and max values of the spectrum allowed
     to be shown, i.e. = maximal ViewLimit allowed}
    UserLimit:TUserViewLimit;{in user units the same part as ViewLimit}

    PointCount:TPointCount; {max size of spectrum in TPointCount units
                             = number of spectrum points collected }
    Extreme:TApexViewLimit; {experimentally found extreme values, peaks;
                              won't be set more then defined Limit}
    XAxisName:PChar;
    YAxisName:PChar;
  end;

  PPeak = ^TPeak;
  TPeak = record
    P1,P2:TIndexPoint;
    X:TApexX;{position of the peak (X of its maximum)}
    Width:TApexX;{width of the peak in the middle of its height}
    Height:TApexY;{max height of the peak}
    AreaSize:TAreaSize;{area of the peak}
    Ratio:real;{ratio AreaSize/(AreaSize of all peaks)}
  end;

  TRunningState = byte;
const
{RunningStates:}
  rsStopped = 0;
  rsReadyToRun = 1;
  rsRunning = 2;
*)
implementation
end.