unit ExtComDl;
////////////////////////////////////////////////////////////////////////////////
// Component Names: TEOpenDialog, TESaveDialog
// Version:         1.0
// Date:            16-Dec-99
// Target:          Win32, Delphi 4 - Delphi 5
// Author:          Bob Daneshfar,   daneshfar@yahoo.com
//
//                  This software is FreeWare and provided "as is" without warranty
//                  of any kind.
//
//                  Please notify me if you make any changes to this file.
////////////////////////////////////////////////////////////////////////////////

//**  property AutoExtention: Boolean
//
//   True:        SaveDialogBox Automatically Changes extention of FileName when
//                User selects a file type
//   False:       SaveDialogBox is like normal delphi TSaveDialog


interface

uses
  Windows, Messages, Classes, SysUtils, Controls, Dialogs, CommDlg;

type
  TEOpenDialog = class(TOpenDialog)
  private
    FAutoExtention: Boolean;
    Procedure SetFileName(Value: TFileName);
    Function GetFName: TFileName;
  Protected
    Procedure DoTypeChange; Override;
  Public
    constructor Create(AOwner: TComponent); override;
    Function CurSelectedExt: String;
    Function GetCurPath: TFileName;
    function Execute: Boolean; override;
  published
    property FileName: TFileName Read GetFName write SetFileName;
    property AutoExtention: Boolean Read FAutoExtention Write FAutoExtention Default False;
  end;

  TESaveDialog = class(TEOpenDialog)
  private
  Protected
  Public
    constructor Create(AOwner: TComponent); override;
    function Execute: Boolean; override;
  Published
    property AutoExtention Default True;
  End;

procedure Register;

implementation
Uses
  Math;
procedure Register;
begin
  RegisterComponents('Dialogs', [TEOpenDialog, TESaveDialog]);
end;

////////////////////////////////////////////////////////////////////////////////
// TEOpenDialog
////////////////////////////////////////////////////////////////////////////////
Procedure TEOpenDialog.SetFileName(Value: TFileName);
begin
  Inherited FileName:= Value;
  if NewStyleControls and (Handle <> 0) then
  begin
    SendMessage(GetParent(Handle), CDM_SETCONTROLTEXT, 1152, Integer(PChar(Value)));
  end;
End;

Function TEOpenDialog.GetFName: TFileName;
Begin
  Result:= Inherited FileName;
End;

Function TEOpenDialog.GetCurPath: TFileName;
var
  Nm: array[0..255] of Char;
begin
  if NewStyleControls and (Handle <> 0) then
  begin
    SendMessage(GetParent(Handle), CDM_GETFOLDERPATH, SizeOf(NM), Integer(@NM));
    Result := StrPas(NM);
  end
  else Result := '';

End;

constructor TEOpenDialog.Create(AOwner: TComponent);
Begin
  FAutoExtention:= False;
  Inherited;
End;

Function TEOpenDialog.CurSelectedExt: String;
Var
  S: String;
  i, j: Integer;
Begin
  Try
    S:= Filter;
    For i:= 1 To FilterIndex - 1 Do
    Begin
      j:= Pos('|', S);
      Delete(S, 1, j);
      j:= Pos('|', S);
      Delete(S, 1, j);
    End;
    j:= Pos('|', S);
    Delete(S, 1, j);
    j:= Pos('|', S);
    If j > 0 Then
      Result:= Copy(S, 1, j - 1)
    Else
      Result:= S;
  Except
    Result:= '';
  End;
  While (Length(Result) > 1) And (Result[1] <> '.') Do Delete(Result, 1, 1);
  If (Length(Result) > 4) Or (Pos('*', Result) > 0) Or (Pos('?', Result) > 0) Then Result:= '';
  If (Result = '') And (DefaultExt <> '') Then
    Result:= '.' + DefaultExt;
End;

procedure TEOpenDialog.DoTypeChange;
Var
  CurPath, CurName: String;
begin
  If FAutoExtention Then
  Begin
    CurPath:= GetCurPath;
    CurName:= FileName;
    If Pos(CurPath, CurName) > 0 Then
      Delete(CurName, 1, Min(Length(CurName), Length(CurPath) + 1));
    If Length(CurName) > 0 Then
      FileName:= ChangeFileExt(CurName, CurSelectedExt);
  End;
  if Assigned(OnTypeChange) then OnTypeChange(Self);
end;

function TEOpenDialog.Execute: Boolean;
Begin
  DoTypeChange;
  Result:= Inherited Execute;
End;

/////////////////////////////////////////////////////////////////////////////////
// TESaveDialog
/////////////////////////////////////////////////////////////////////////////////
constructor TESaveDialog.Create(AOwner: TComponent);
Begin
  Inherited;
  FAutoExtention:= True;
End;

function TESaveDialog.Execute: Boolean;
Begin
  Result:= DoExecute(@GetSaveFileName);
End;

end.
