unit URLLabel;
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ShellApi;

type
  TUrlKind = (ukHttp, ukEmail);

  TURLLabel = class(TLabel)
  private
    FUrlKind: TUrlKind;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    procedure Click; override;
  published
    property UrlKind: TUrlKind read FUrlKind write FUrlKind;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Chromulan', [TURLLabel]);
end;

procedure TURLLabel.Click;
var
  s: string;
begin
  inherited Click;
  case FUrlKind of
    ukEMail: ShellExecute(0, 'open', PChar('mailto:' + Caption), '', '', SW_SHOWNORMAL)
  else
    if pos('://', Caption) = 0 then
      s := 'http://' + Caption
    else
      s := Caption;
    ShellExecute(0, 'open', PChar(s), '', '', SW_SHOWNORMAL);
  end;
end;

constructor TURLLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Font.Style:= [fsUnderline];
  Font.Color := clBlue;
  Cursor:= crHandPoint;
end;

end.

