unit SeqPrgLCPbs1;

interface

const
  lcpltNull=0;
  lcpltFlow=1;
  lcpltGradient=2;
  lcpltAuxOut=3;
  lcpltPrgEnd=4;
  lcpltWaitSW_Mark=5;
  lcpltSendMark=6;
  lcpltAuxValv=7;
  lcpltGradValv=8;
  lcpltPressCorr=9;
 {v0.70pi}
  lcpltSlAuxValv=10;
  lcpltSlGradValv=11;
 {/v0.70pi}
  lcpltProgName=$40;

type
  TlcpbsLineHead=packed record
    LineSize:Byte;	{ Length of header and line contents }
    LineType:Byte;      { Information about line type lcpltXXXX}
  end;

  TlcpbsLineFlow=packed record		{ LineType=1 }
    Time:Word;		{ Time in step 0.01 min }
    Flow:Word;		{ Flow in step 0.001 ml/min }
    AproxStep:Word;
    AproxRemind:Word;
    AproxTime:Word;
  end;

  TlcpbsLineGradient=packed record	{ LineType=2 }
    Time:Word;		{ Time in step 0.01 min }
    GradB:Word;		{ [%] of gradient B multiplyed by 256 }
    AproxBStep:Word;
    AproxBRemind:Word;
    AproxBTime:Word;
    GradC:Word;		{ [%] of gradient C multiplyed by 256 }
    AproxCStep:Word;
    AproxCRemind:Word;
    AproxCTime:Word;
  end;

  TlcpbsLineAuxOut=packed record	{ LineType=3 }
    Time:Word;		{ Time in step 0.01 min }
    AuxOut:Word;	{ Bits 0..3 are sent to TTL outputs }
  end;

  TlcpbsLinePrgEnd=packed record	{ LineType=4 }
    Time:Word;		{ Time in step 0.01 min }
  end;

  TlcpbsLineWaitSW_Mark=packed record	{ LineType=5 }
    Time:Word;		{ Time in step 0.01 min }
    Res1:Word;
  end;

  TlcpbsLineSendMark=packed record	{ LineType=6 }
    Time:Word;		{ Time in step 0.01 min }
    DestAddr:Word;	{ Destination module address }
  end;

  TlcpbsLineAuxValv=packed record	{ LineType=7 }
    Time:Word;		{ Time in step 0.01 min }
    AuxValv:Word;	{ Switch to valve 1..8 connected to TTL outs  }
  end;

  TlcpbsLineGradValv=packed record	{ LineType=8 }
    Time:Word;		{ Time in step 0.01 min }
    GradValv:Word;	{ Switch to gradient valve 0=A,1=B,2=C }
  end;

  TlcpbsLinePressCorr=packed record	{ LineType=9 }
    Time:Word;		{ Time in step 0.01 min }
    PressCorr:Word;	{ Factor for elimination liquid compressibility }
  end;

  TlcpbsLineProgName=packed record      { LineType=0x40 }
    Name:string[10];
    Res1:Word;
    Res2:Word;
  end;

  TlcpbsLine=packed record
    Head:TlcpbsLineHead;
  case Byte of
    lcpltFlow:      (Flow:TlcpbsLineFlow);
    lcpltGradient:  (Gradient:TlcpbsLineGradient);
    lcpltAuxOut:    (AuxOut:TlcpbsLineAuxOut);
    lcpltPrgEnd:    (PrgEnd:TlcpbsLinePrgEnd);
    lcpltWaitSW_Mark:(WaitSW_Mark:TlcpbsLineWaitSW_Mark);
    lcpltSendMark:  (SendMark:TlcpbsLineSendMark);
    lcpltAuxValv:   (AuxValv:TlcpbsLineAuxValv);
    lcpltGradValv:  (GradValv:TlcpbsLineGradValv);
    lcpltPressCorr: (PressCorr:TlcpbsLinePressCorr);
    lcpltProgName:  (ProgName:TlcpbsLineProgName);
  end;

Implementation

end.
